/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DistillationTowerTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.gui.IPMenuProvider;
import flaxbeard.immersivepetroleum.common.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.util.AABBUtils;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class DerrickTileEntity
extends PoweredMultiblockBlockEntity<DerrickTileEntity, MultiblockRecipe>
implements IPCommonTickableTile,
IPMenuProvider<DerrickTileEntity>,
IEBlockInterfaces.IBlockBounds {
    public static final int REQUIRED_WATER_AMOUNT = 125;
    public static final int REQUIRED_CONCRETE_AMOUNT = 125;
    public static final FluidTank DUMMY_TANK = new FluidTank(0);
    public static final BlockPos Fluid_IN = new BlockPos(2, 0, 4);
    public static final BlockPos Fluid_OUT = new BlockPos(4, 0, 2);
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 1));
    public final FluidTank tank = new FluidTank(8000, this::acceptsFluid);
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public boolean drilling;
    public boolean spilling;
    private int clientFlow;
    public int timer = 0;
    private Fluid fluidSpilled = Fluids.f_76191_;
    @Nullable
    public PipeConfig.Grid gridStorage;
    public int rotation = 0;
    private WellTileEntity wellCache = null;
    private final MultiblockCapability<IFluidHandler> fluidInputHandler = MultiblockCapability.make((Object)this, be -> be.fluidInputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tank}));
    private final ResettableCapability<IFluidHandler> dummyTank = this.registerFluidOutput(new IFluidTank[]{DUMMY_TANK});
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(DerrickTileEntity::getShape);

    public DerrickTileEntity(BlockEntityType<DerrickTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)DerrickMultiblock.INSTANCE, 16000, true, type, pWorldPosition, pBlockState);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.drilling = nbt.m_128471_("drilling");
        this.spilling = nbt.m_128471_("spilling");
        this.clientFlow = nbt.m_128451_("flow");
        this.timer = nbt.m_128451_("timer");
        try {
            this.fluidSpilled = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("spillingfluid")));
        }
        catch (ResourceLocationException rle) {
            this.fluidSpilled = Fluids.f_76191_;
        }
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        if (nbt.m_128425_("grid", 10)) {
            this.gridStorage = PipeConfig.Grid.fromCompound(nbt.m_128469_("grid"));
        }
        if (!descPacket && !this.isDummy()) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
            this.m_6596_();
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128379_("drilling", this.drilling);
        nbt.m_128379_("spilling", this.spilling);
        nbt.m_128405_("timer", this.timer);
        nbt.m_128359_("spillingfluid", this.fluidSpilled.getRegistryName().toString());
        nbt.m_128405_("flow", this.getReservoirFlow());
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        if (this.gridStorage != null) {
            nbt.m_128365_("grid", (Tag)this.gridStorage.toCompound());
        }
        if (!descPacket && !this.isDummy()) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    private boolean acceptsFluid(FluidStack fs) {
        int waterNeeded;
        boolean isWater;
        if (fs.isEmpty()) {
            return false;
        }
        WellTileEntity well = this.getOrCreateWell(false);
        if (well == null) {
            return false;
        }
        Fluid inFluid = fs.getFluid();
        boolean isConcrete = inFluid == ExternalModContent.getIEFluid_Concrete();
        boolean bl = isWater = inFluid == Fluids.f_76193_;
        if (!isConcrete && !isWater) {
            return false;
        }
        int realPipeLength = this.m_58899_().m_123342_() - 1 - well.m_58899_().m_123342_();
        int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
        if (concreteNeeded > 0 && isConcrete) {
            FluidStack tankFluidStack = this.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= concreteNeeded) {
                return false;
            }
            return concreteNeeded >= fs.getAmount();
        }
        if (concreteNeeded <= 0 && (waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength)) > 0 && isWater) {
            FluidStack tankFluidStack = this.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= waterNeeded) {
                return false;
            }
            return waterNeeded >= fs.getAmount();
        }
        return false;
    }

    @Override
    public void tickClient() {
        if (this.drilling) {
            this.rotation += 9;
            this.rotation %= 360;
            for (int i = 0; i < 10; ++i) {
                float rx = (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 1.5f;
                float rz = (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 1.5f;
                if ((double)rx > -0.625 && (double)rx < 0.625 && (double)rz > -0.625 && (double)rz < 0.625) continue;
                float xa = (this.f_58857_.f_46441_.nextFloat() - 0.5f) / 16.0f;
                float ya = 0.01f * this.f_58857_.f_46441_.nextFloat();
                float za = (this.f_58857_.f_46441_.nextFloat() - 0.5f) / 16.0f;
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)rx;
                double y = (double)this.f_58858_.m_123342_() + 1.625 + (double)this.f_58857_.f_46441_.nextFloat();
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)rz;
                this.f_58857_.m_7106_((ParticleOptions)(this.f_58857_.f_46441_.nextFloat() < 0.5f ? ParticleTypes.f_123762_ : ParticleTypes.f_123755_), x, y, z, (double)xa, (double)ya, (double)za);
            }
        }
        if (this.spilling) {
            ClientProxy.spawnSpillParticles(this.f_58857_, this.f_58858_, this.fluidSpilled, 5, 15.75f, this.clientFlow);
        }
    }

    @Override
    public void tickServer() {
        if (this.isDummy()) {
            return;
        }
        if (this.f_58857_.isAreaLoaded(this.m_58899_(), 2)) {
            boolean forceUpdate = false;
            boolean lastDrilling = this.drilling;
            boolean lastSpilling = this.spilling;
            this.spilling = false;
            this.drilling = false;
            if (this.f_58858_.m_123342_() < this.f_58857_.m_5736_()) {
                if (this.fluidSpilled == Fluids.f_76191_) {
                    this.fluidSpilled = Fluids.f_76193_;
                }
                this.spilling = true;
            } else {
                WellTileEntity well = this.getOrCreateWell(this.getInventory(Inventory.INPUT) != ItemStack.f_41583_);
                if (!this.isRSDisabled() && this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), true) >= (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get() && well != null && well.wellPipeLength < well.getMaxPipeLength()) {
                    ItemStack stack;
                    if (well.pipes <= 0 && this.getInventory(Inventory.INPUT) != ItemStack.f_41583_ && (stack = this.getInventory(Inventory.INPUT)).m_41613_() > 0) {
                        stack.m_41774_(1);
                        well.pipes = 6;
                        if (stack.m_41613_() <= 0) {
                            this.setInventory(Inventory.INPUT, ItemStack.f_41583_);
                        }
                        well.m_6596_();
                        forceUpdate = true;
                    }
                    if (well.pipes > 0) {
                        BlockPos dPos = this.m_58899_();
                        BlockPos wPos = well.m_58899_();
                        int realPipeLength = dPos.m_123342_() - 1 - wPos.m_123342_();
                        if (well.phyiscalPipesList.size() < realPipeLength && well.wellPipeLength < realPipeLength) {
                            if (this.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                                this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                                if (this.advanceTimer()) {
                                    BlockPos current;
                                    BlockState state;
                                    Level world = this.getLevelNonnull();
                                    for (int y = dPos.m_123342_() - 1; y > wPos.m_123342_() && (state = world.m_8055_(current = new BlockPos(dPos.m_123341_(), y, dPos.m_123343_()))).m_60734_() != Blocks.f_50752_ && state.m_60734_() != IPContent.Blocks.WELL.get(); --y) {
                                        if (state.m_60734_() == IPContent.Blocks.WELL_PIPE.get() && !((Boolean)state.m_61143_((Property)WellPipeBlock.BROKEN)).booleanValue()) continue;
                                        world.m_46961_(current, false);
                                        world.m_46597_(current, ((WellPipeBlock)((Object)IPContent.Blocks.WELL_PIPE.get())).m_49966_());
                                        well.phyiscalPipesList.add(y);
                                        this.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                        well.usePipe();
                                        break;
                                    }
                                    if (well.phyiscalPipesList.size() >= realPipeLength && well.wellPipeLength >= realPipeLength) {
                                        well.pastPhysicalPart = true;
                                        well.m_6596_();
                                    }
                                }
                                forceUpdate = true;
                                this.drilling = true;
                            }
                        } else {
                            if (!this.tank.getFluid().isEmpty() && this.tank.getFluid().getFluid() == ExternalModContent.getIEFluid_Concrete()) {
                                this.tank.drain(this.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                                forceUpdate = true;
                            }
                            if (this.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                                this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                                if (this.advanceTimer()) {
                                    this.restorePhysicalPipeProgress(dPos, realPipeLength);
                                    this.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                    well.usePipe();
                                }
                                forceUpdate = true;
                                this.drilling = true;
                            }
                        }
                    }
                }
                if (well != null && well.wellPipeLength == well.getMaxPipeLength()) {
                    this.outputReservoirFluid();
                }
            }
            if (forceUpdate || lastDrilling != this.drilling || lastSpilling != this.spilling || (double)Math.abs(this.getReservoirFlow() - this.clientFlow) > 0.075 * (double)this.clientFlow) {
                this.updateMasterBlock(null, true);
                this.m_6596_();
            }
        }
    }

    private boolean advanceTimer() {
        if (this.timer-- <= 0) {
            this.timer = 10;
            return true;
        }
        return false;
    }

    private int getReservoirFlow() {
        return ReservoirHandler.getIsland(this.getLevelNonnull(), this.m_58899_()) == null || this.f_58858_.m_123342_() < this.getLevelNonnull().m_5736_() ? 10 : ReservoirIsland.getFlow(ReservoirHandler.getIsland(this.getLevelNonnull(), this.m_58899_()).getPressure(this.getLevelNonnull(), this.m_58899_().m_123341_(), this.m_58899_().m_123343_()));
    }

    public void restorePhysicalPipeProgress(BlockPos dPos, int realPipeLength) {
        if (this.wellCache == null) {
            return;
        }
        int min = Math.min(this.wellCache.wellPipeLength, realPipeLength);
        for (int i = 1; i < min; ++i) {
            BlockPos current = new BlockPos(dPos.m_123341_(), dPos.m_123342_() - i, dPos.m_123343_());
            BlockState state = this.getLevelNonnull().m_8055_(current);
            if (state.m_60734_() == IPContent.Blocks.WELL_PIPE.get()) continue;
            this.getLevelNonnull().m_46961_(current, false);
            this.getLevelNonnull().m_46597_(current, ((WellPipeBlock)((Object)IPContent.Blocks.WELL_PIPE.get())).m_49966_());
        }
    }

    private void outputReservoirFluid() {
        WellTileEntity well = this.getOrCreateWell(true);
        if (well == null) {
            return;
        }
        FluidStack extracted = this.getExtractedFluidStack(well);
        if (!extracted.isEmpty()) {
            Direction facing = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).m_5484_(facing, 1);
            IFluidHandler output = (IFluidHandler)FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outPos, (Direction)facing.m_122424_()).orElse(null);
            if (output != null) {
                FluidStack fluid = FluidHelper.copyFluid(extracted, extracted.getAmount());
                int accepted = output.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    boolean iePipe = this.f_58857_.m_7702_(outPos) instanceof IFluidPipe;
                    int drained = output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                    if (fluid.getAmount() - drained > 0) {
                        this.spilling = true;
                    }
                } else {
                    this.spilling = true;
                }
            } else {
                this.spilling = true;
            }
        }
        if (this.spilling && !extracted.isEmpty() && this.fluidSpilled != extracted.getFluid()) {
            this.fluidSpilled = extracted.getFluid();
        }
        if (!this.spilling && this.fluidSpilled != Fluids.f_76191_) {
            this.fluidSpilled = Fluids.f_76191_;
        }
    }

    private FluidStack getExtractedFluidStack(@Nonnull WellTileEntity well) {
        Fluid extractedFluid = Fluids.f_76191_;
        int extractedAmount = 0;
        for (ColumnPos cPos : well.tappedIslands) {
            ReservoirIsland island = ReservoirHandler.getIsland(this.f_58857_, cPos);
            if (island == null) continue;
            if (extractedFluid == Fluids.f_76191_) {
                extractedFluid = island.getFluid();
            } else if (island.getFluid() != extractedFluid) continue;
            extractedAmount += island.extractWithPressure(this.getLevelNonnull(), cPos.f_140723_, cPos.f_140724_);
        }
        return new FluidStack(extractedFluid, extractedAmount);
    }

    public WellTileEntity getOrCreateWell(boolean popList) {
        if (this.wellCache != null && this.wellCache.m_58901_()) {
            this.wellCache = null;
        }
        if (this.wellCache == null) {
            Level world = this.getLevelNonnull();
            WellTileEntity well = null;
            for (int y = this.m_58899_().m_123342_() - 1; y >= world.m_141937_(); --y) {
                BlockPos current = new BlockPos(this.m_58899_().m_123341_(), y, this.m_58899_().m_123343_());
                BlockState state = world.m_8055_(current);
                if (state.m_60734_() == IPContent.Blocks.WELL.get()) {
                    well = (WellTileEntity)world.m_7702_(current);
                    break;
                }
                if (state.m_60734_() != Blocks.f_50752_) continue;
                world.m_46597_(current, ((WellBlock)((Object)IPContent.Blocks.WELL.get())).m_49966_());
                well = (WellTileEntity)world.m_7702_(current);
                break;
            }
            this.wellCache = well;
        }
        if (popList && this.wellCache != null && this.wellCache.tappedIslands.isEmpty()) {
            if (this.gridStorage != null) {
                this.transferGridDataToWell(this.wellCache);
            } else {
                this.wellCache.tappedIslands.add(new ColumnPos(this.f_58858_.m_123341_(), this.f_58858_.m_123343_()));
                this.wellCache.m_6596_();
            }
        }
        if (this.wellCache != null) {
            this.wellCache.abortSelfDestructSequence();
        }
        return this.wellCache;
    }

    @Nullable
    public WellTileEntity getWell() {
        if (this.wellCache != null && this.wellCache.m_58901_()) {
            this.wellCache = null;
        }
        if (this.wellCache == null) {
            Level world = this.getLevelNonnull();
            WellTileEntity well = null;
            for (int y = this.m_58899_().m_123342_() - 1; y >= world.m_141937_(); --y) {
                BlockPos current = new BlockPos(this.m_58899_().m_123341_(), y, this.m_58899_().m_123343_());
                BlockState state = world.m_8055_(current);
                if (state.m_60734_() != IPContent.Blocks.WELL.get()) continue;
                well = (WellTileEntity)world.m_7702_(current);
                break;
            }
            this.wellCache = well;
        }
        return this.wellCache;
    }

    public void transferGridDataToWell(@Nullable WellTileEntity well) {
        if (well != null) {
            int additionalPipes = 0;
            ArrayList<ColumnPos> list = new ArrayList<ColumnPos>();
            PipeConfig.Grid grid = this.gridStorage;
            for (int j = 0; j < grid.getHeight(); ++j) {
                for (int i = 0; i < grid.getWidth(); ++i) {
                    int type = grid.get(i, j);
                    if (type <= 0) continue;
                    switch (type) {
                        case 2: 
                        case 3: {
                            int x = i - grid.getWidth() / 2;
                            int z = j - grid.getHeight() / 2;
                            ColumnPos pos = new ColumnPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123343_() + z);
                            list.add(pos);
                        }
                        case 1: {
                            ++additionalPipes;
                        }
                    }
                }
            }
            well.tappedIslands = list;
            well.additionalPipes = additionalPipes;
            well.m_6596_();
        }
    }

    public void disassemble() {
        if (this.formed && !this.f_58857_.f_46443_) {
            DerrickTileEntity master = (DerrickTileEntity)this.master();
            Level world = master.getLevelNonnull();
            BlockPos dPos = master.m_58899_();
            for (int y = this.m_58899_().m_123342_() - 1; y >= world.m_141937_(); --y) {
                BlockPos current = new BlockPos(dPos.m_123341_(), y, dPos.m_123343_());
                BlockEntity teLow = world.m_7702_(current);
                if (!(teLow instanceof WellTileEntity)) continue;
                WellTileEntity well = (WellTileEntity)teLow;
                if (well.drillingCompleted) continue;
                if (well.wellPipeLength > 0) {
                    well.startSelfDestructSequence();
                    break;
                }
                world.m_46597_(current, Blocks.f_50752_.m_49966_());
                break;
            }
        }
        super.disassemble();
    }

    public ItemStack getInventory(Inventory inv) {
        return (ItemStack)this.inventory.get(inv.id());
    }

    public ItemStack setInventory(Inventory inv, ItemStack stack) {
        return (ItemStack)this.inventory.set(inv.id(), (Object)stack);
    }

    public DerrickTileEntity getGuiMaster() {
        return (DerrickTileEntity)this.master();
    }

    @Override
    @Nonnull
    public IPMenuProvider.BEContainerIP<? super DerrickTileEntity, ?> getContainerTypeIP() {
        return IPMenuTypes.DERRICK;
    }

    public boolean canUseGui(@Nonnull Player player) {
        return this.formed;
    }

    public boolean skipGui(BlockHitResult hit) {
        Direction facing = this.getFacing();
        if (DistillationTowerTileEntity.Energy_IN.stream().anyMatch(t -> t.posInMultiblock() == this.posInMultiblock) && hit.m_82434_() == Direction.UP) {
            return true;
        }
        return Redstone_IN.contains(this.posInMultiblock) && (this.getIsMirrored() ? hit.m_82434_() == facing.m_122427_() : hit.m_82434_() == facing.m_122428_());
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    protected MultiblockRecipe getRecipeForId(Level level, ResourceLocation id) {
        return null;
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || side == this.getFacing().m_122424_())) {
                return this.fluidInputHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || (this.getIsMirrored() ? side == this.getFacing().m_122428_() : side == this.getFacing().m_122427_()))) {
                return this.dummyTank.cast();
            }
        }
        return super.getCapability(capability, side);
    }

    public boolean isLadder() {
        int x = this.posInMultiblock.m_123341_();
        int y = this.posInMultiblock.m_123342_();
        int z = this.posInMultiblock.m_123343_();
        if (x == 0 && z == 2 && y >= 0 && y <= 8) {
            return true;
        }
        return x == 1 && z == 2 && y >= 9 && y <= 14;
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int x = posInMultiblock.m_123341_();
        int y = posInMultiblock.m_123342_();
        int z = posInMultiblock.m_123343_();
        ArrayList<AABB> main = new ArrayList<AABB>();
        if (!(y != 0 || x == 2 && z == 4 || x == 4 && z == 2 || x == 2 && z == 0 || x == 2 && z == 2)) {
            AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
        }
        if (!(y != 8 && y != 14 || x == 2 && z == 2 || x == 0 && z == 2 || x == 1 && z == 2)) {
            AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
        }
        if (y == 0 || y == 1) {
            if (z == 0) {
                if (x == 1) {
                    AABBUtils.box16(main, 4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
                } else if (x == 3) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
                }
            }
            if (x == 1 && z == 4) {
                AABBUtils.box16(main, 8.0, 8.0, 0.0, 16.0, 24.0, 16.0);
            } else if (x == 3 && z == 4) {
                AABBUtils.box16(main, 0.0, 8.0, 0.0, 8.0, 24.0, 16.0);
            }
            if (y == 1 && x == 2 && z == 4) {
                AABBUtils.box16(main, -8.0, 0.0, 0.0, 24.0, 8.0, 16.0);
            }
        }
        if (x == 2 && z == 2 && y >= 0 && y <= 13) {
            if (y == 0) {
                AABBUtils.box16(main, -4.0, 8.0, -4.0, 20.0, 16.0, 20.0);
                main.add(AABBUtils.FULL);
            } else if (y > 1) {
                AABBUtils.box16(main, 4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
            }
            if (y == 1) {
                AABBUtils.box16(main, -4.0, 0.0, -4.0, 20.0, 8.0, 20.0);
                main.add(AABBUtils.FULL);
            }
            if (y == 2) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
            }
        }
        if (x == 0 && z == 2 && y >= 1 && y <= 8) {
            if (y == 1) {
                AABBUtils.box16(main, 15.0, 8.0, 2.0, 16.0, 16.0, 14.0);
            } else {
                AABBUtils.box16(main, 15.0, 0.0, 2.0, 16.0, 16.0, 14.0);
            }
            if (y > 2) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
                AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
            }
        }
        if (x == 1 && z == 2 && y >= 9 && y <= 14) {
            if (y == 9) {
                AABBUtils.box16(main, 15.0, 8.0, 2.0, 16.0, 16.0, 14.0);
            } else {
                AABBUtils.box16(main, 15.0, 0.0, 2.0, 16.0, 16.0, 14.0);
            }
            if (y > 10) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
                AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
            }
        }
        if (y >= 0 && y <= 8) {
            if (x == 0 && z == 0) {
                AABBUtils.box16(main, 9 + y, 0.0, 9 + y, 15 + y, 16.0, 15 + y);
            } else if (x == 4 && z == 0) {
                AABBUtils.box16(main, 1 - y, 0.0, 9 + y, 7 - y, 16.0, 15 + y);
            } else if (x == 0 && z == 4) {
                AABBUtils.box16(main, 9 + y, 0.0, 1 - y, 15 + y, 16.0, 7 - y);
            } else if (x == 4 && z == 4) {
                AABBUtils.box16(main, 1 - y, 0.0, 1 - y, 7 - y, 16.0, 7 - y);
            }
            if (y >= 3) {
                if (x == 2 && z == 0) {
                    AABBUtils.box16(main, 6.0, 0.0, 9 + y, 10.0, 16.0, 14 + y);
                } else if (x == 2 && z == 4) {
                    AABBUtils.box16(main, 6.0, 0.0, 2 - y, 10.0, 16.0, 7 - y);
                } else if (x == 4 && z == 2) {
                    AABBUtils.box16(main, 2 - y, 0.0, 6.0, 7 - y, 16.0, 10.0);
                }
            }
            if (y == 3) {
                if (x >= 1 && x <= 3) {
                    if (z == 0) {
                        AABBUtils.box16(main, 0.0, -4.0, 12.0, 16.0, 0.0, 16.0);
                    } else if (z == 4) {
                        AABBUtils.box16(main, 0.0, -4.0, 0.0, 16.0, 0.0, 4.0);
                    }
                }
                if (z >= 1 && z <= 3) {
                    if (x == 0 && z != 2) {
                        AABBUtils.box16(main, 12.0, -4.0, 0.0, 16.0, 0.0, 16.0);
                    } else if (x == 4) {
                        AABBUtils.box16(main, 0.0, -4.0, 0.0, 4.0, 0.0, 16.0);
                    }
                }
            }
            if (y == 6) {
                if (x >= 1 && x <= 3) {
                    if (z == 0) {
                        AABBUtils.box16(main, 0.0, 4.0, 16.0, 16.0, 8.0, 20.0);
                    } else if (z == 4) {
                        AABBUtils.box16(main, 0.0, 4.0, -4.0, 16.0, 8.0, 0.0);
                    }
                }
                if (z >= 1 && z <= 3) {
                    if (x == 0) {
                        AABBUtils.box16(main, 16.0, 4.0, 0.0, 20.0, 8.0, 16.0);
                    } else if (x == 4) {
                        AABBUtils.box16(main, -4.0, 4.0, 0.0, 0.0, 8.0, 16.0);
                    }
                }
            }
        }
        if (y >= 9 && y <= 16) {
            double off = y - 9;
            if (x == 1 && z == 1) {
                AABBUtils.box16(main, 2.0 + off, 0.0, 2.0 + off, 7.0 + off, 16.0, 7.0 + off);
            } else if (x == 3 && z == 1) {
                AABBUtils.box16(main, 9.0 - off, 0.0, 2.0 + off, 14.0 - off, 16.0, 7.0 + off);
            } else if (x == 1 && z == 3) {
                AABBUtils.box16(main, 2.0 + off, 0.0, 9.0 - off, 7.0 + off, 16.0, 14.0 - off);
            } else if (x == 3 && z == 3) {
                AABBUtils.box16(main, 9.0 - off, 0.0, 9.0 - off, 14.0 - off, 16.0, 14.0 - off);
            }
            if (x == 2 && z == 1) {
                AABBUtils.box16(main, 6.0, 0.0, 2.0 + off, 10.0, 16.0, 6.0 + off);
            } else if (x == 2 && z == 3) {
                AABBUtils.box16(main, 6.0, 0.0, 10.0 - off, 10.0, 16.0, 14.0 - off);
            } else if (x == 3 && z == 2) {
                AABBUtils.box16(main, 10.0 - off, 0.0, 6.0, 14.0 - off, 16.0, 10.0);
            }
            if (y == 9) {
                if (x == 3) {
                    if (z == 1) {
                        AABBUtils.box16(main, 9.0, 12.0, 7.0, 13.0, 16.0, 16.0);
                    } else if (z == 2) {
                        AABBUtils.box16(main, 9.0, 12.0, 0.0, 13.0, 16.0, 16.0);
                    } else if (z == 3) {
                        AABBUtils.box16(main, 9.0, 12.0, 0.0, 13.0, 16.0, 9.0);
                    }
                }
                if (z == 1) {
                    if (x == 1) {
                        AABBUtils.box16(main, 7.0, 12.0, 3.0, 16.0, 16.0, 7.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 12.0, 3.0, 16.0, 16.0, 7.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 12.0, 3.0, 9.0, 16.0, 7.0);
                    }
                } else if (z == 3) {
                    if (x == 1) {
                        AABBUtils.box16(main, 7.0, 12.0, 9.0, 16.0, 16.0, 13.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 12.0, 9.0, 16.0, 16.0, 13.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 12.0, 9.0, 9.0, 16.0, 13.0);
                    }
                }
            }
            if (y == 13) {
                if (x == 3) {
                    if (z == 1) {
                        AABBUtils.box16(main, 5.0, 4.0, 11.0, 9.0, 8.0, 16.0);
                    } else if (z == 2) {
                        AABBUtils.box16(main, 5.0, 4.0, 0.0, 9.0, 8.0, 16.0);
                    } else if (z == 3) {
                        AABBUtils.box16(main, 5.0, 4.0, 0.0, 9.0, 8.0, 5.0);
                    }
                }
                if (z == 1) {
                    if (x == 1) {
                        AABBUtils.box16(main, 11.0, 4.0, 7.0, 16.0, 8.0, 11.0);
                        AABBUtils.box16(main, 7.0, 4.0, 11.0, 11.0, 8.0, 16.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 4.0, 7.0, 16.0, 8.0, 11.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 4.0, 7.0, 5.0, 8.0, 11.0);
                    }
                } else if (z == 3) {
                    if (x == 1) {
                        AABBUtils.box16(main, 11.0, 4.0, 5.0, 16.0, 8.0, 9.0);
                        AABBUtils.box16(main, 7.0, 4.0, 0.0, 11.0, 8.0, 5.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 4.0, 5.0, 16.0, 8.0, 9.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 4.0, 5.0, 5.0, 8.0, 9.0);
                    }
                }
            }
            if (y == 16) {
                if (z == 1) {
                    if (x == 1) {
                        AABBUtils.box16(main, 9.0, 12.0, 9.0, 16.0, 16.0, 16.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 12.0, 9.0, 16.0, 16.0, 15.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 12.0, 9.0, 7.0, 16.0, 16.0);
                    }
                }
                if (z == 2) {
                    if (x == 1) {
                        AABBUtils.box16(main, 9.0, 12.0, 0.0, 15.0, 16.0, 16.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 1.0, 12.0, 0.0, 7.0, 16.0, 16.0);
                    }
                }
                if (z == 3) {
                    if (x == 1) {
                        AABBUtils.box16(main, 9.0, 12.0, 0.0, 16.0, 16.0, 7.0);
                    } else if (x == 2) {
                        AABBUtils.box16(main, 0.0, 12.0, 1.0, 16.0, 16.0, 7.0);
                    } else if (x == 3) {
                        AABBUtils.box16(main, 0.0, 12.0, 0.0, 7.0, 16.0, 7.0);
                    }
                }
            }
        }
        if (main.isEmpty()) {
            main.add(AABBUtils.FULL);
        }
        return main;
    }

    public static enum Inventory {
        INPUT;


        public int id() {
            return this.ordinal();
        }
    }
}

