/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.impl.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GasGeneratorTileEntity
extends ImmersiveConnectableBlockEntity
implements IPCommonTickableTile,
IEBlockInterfaces.IDirectionalBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.ISoundBE,
EnergyTransferHandler.EnergyConnector {
    public static final int FUEL_CAPACITY = 8000;
    protected WireType wireType;
    protected boolean isActive = false;
    protected int fluidTick = 0;
    protected int currentFlux = 0;
    protected Direction facing = Direction.NORTH;
    protected final MutableEnergyStorage energyStorage = new MutableEnergyStorage(this.getMaxStorage(), Integer.MAX_VALUE, this.getMaxOutput());
    protected final FluidTank tank = new FluidTank(8000, fluid -> fluid != FluidStack.EMPTY && FuelHandler.isValidFuel(fluid.getFluid()));
    private final LazyOptional<IFluidHandler> fluidHandler = CapabilityUtils.constantOptional((Object)this.tank);
    private final LazyOptional<IEnergyStorage> energyHandler = CapabilityUtils.constantOptional((Object)this.energyStorage);

    public GasGeneratorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.GENERATOR.get(), pWorldPosition, pBlockState);
    }

    public int getMaxOutput() {
        return IEServerConfig.MACHINES.lvCapConfig.output.getAsInt();
    }

    private int getMaxStorage() {
        return IEServerConfig.MACHINES.lvCapConfig.storage.getAsInt();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isActive = nbt.m_128471_("isActive");
        this.fluidTick = nbt.m_128451_("fluidTick");
        this.currentFlux = nbt.m_128451_("currentFlux");
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        WireType wireType = this.wireType = nbt.m_128441_("wiretype") ? WireUtils.getWireTypeFromNBT((CompoundTag)nbt, (String)"wiretype") : null;
        if (nbt.m_128441_("buffer")) {
            this.energyStorage.deserializeNBT(nbt.m_128423_("buffer"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("fluidTick", this.fluidTick);
        nbt.m_128405_("currentFlux", this.currentFlux);
        nbt.m_128379_("isActive", this.isActive);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128365_("buffer", this.energyStorage.serializeNBT());
        if (this.wireType != null) {
            nbt.m_128359_("wiretype", this.wireType.getUniqueName());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, b -> this.m_5995_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41784_();
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.energyStorage.deserializeNBT(nbt.m_128423_("energy"));
        }
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    @Nonnull
    public List<ItemStack> getBlockEntityDrop(@Nullable LootContext context) {
        ItemStack stack = context != null ? new ItemStack((ItemLike)((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_()) : new ItemStack((ItemLike)this.m_58900_().m_60734_());
        CompoundTag nbt = new CompoundTag();
        if (this.tank.getFluidAmount() > 0) {
            CompoundTag tankNbt = this.tank.writeToNBT(new CompoundTag());
            nbt.m_128365_("tank", (Tag)tankNbt);
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            Tag energyNbt = this.energyStorage.serializeNBT();
            nbt.m_128365_("energy", energyNbt);
        }
        if (!nbt.m_128456_()) {
            stack.m_41751_(nbt);
        }
        return ImmutableList.of((Object)stack);
    }

    public int getAvailableEnergy() {
        return Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
    }

    public void extractEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
    }

    public boolean isSource(ConnectionPoint cp) {
        return true;
    }

    public boolean isSink(ConnectionPoint cp) {
        return false;
    }

    public boolean shouldPlaySound(@Nonnull String sound) {
        return this.isActive;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == Direction.UP)) {
            return this.fluidHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY && (side == null || side == this.facing)) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        this.energyHandler.invalidate();
    }

    public Component[] getOverlayText(Player player, @Nonnull HitResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            Object s = null;
            s = this.tank.getFluid().getAmount() > 0 ? ((MutableComponent)this.tank.getFluid().getDisplayName()).m_130946_(": " + this.tank.getFluidAmount() + "mB") : new TranslatableComponent("gui.immersiveengineering.empty");
            return new Component[]{s};
        }
        return null;
    }

    public boolean useNixieFont(@Nonnull Player player, @Nonnull HitResult mop) {
        return false;
    }

    public boolean interact(@Nonnull Direction side, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
            this.m_6596_();
            flaxbeard.immersivepetroleum.common.util.Utils.unlockIPAdvancement(player, "main/gas_generator");
            return true;
        }
        if (player.m_6144_()) {
            boolean added = false;
            if (player.m_150109_().m_36056_().m_41619_()) {
                added = true;
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, this.getBlockEntityDrop(null).get(0));
            } else {
                added = player.m_150109_().m_36054_(this.getBlockEntityDrop(null).get(0));
            }
            if (added) {
                this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull Direction facing) {
        this.facing = facing;
    }

    @Nonnull
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull LivingEntity placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull Direction side, @Nonnull Vec3 hit, @Nonnull LivingEntity entity) {
        return true;
    }

    @Override
    public void tickClient() {
        ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, (BlockEntity)this, this.isActive, 0.3f, 0.75f);
        if (this.isActive && this.f_58857_.m_46467_() % 4L == 0L) {
            Direction fl = this.facing;
            Direction fw = this.facing.m_122427_();
            Vec3i vec = fw.m_122424_().m_122436_();
            double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)((float)(fl.m_122429_() * 2) / 16.0f) + (double)((float)(-fw.m_122429_()) * 0.6125f);
            double y = (double)this.f_58858_.m_123342_() + 0.4;
            double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)((float)(fl.m_122431_() * 2) / 16.0f) + (double)((float)(-fw.m_122431_()) * 0.6125f);
            this.f_58857_.m_7106_((ParticleOptions)(this.f_58857_.f_46441_.nextInt(10) == 0 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_), x, y, z, (double)vec.m_123341_() * 0.025, 0.0, (double)vec.m_123343_() * 0.025);
        }
    }

    @Override
    public void tickServer() {
        boolean lastActive = this.isActive;
        this.isActive = false;
        if (!this.f_58857_.m_46753_(this.f_58858_)) {
            Fluid fluid;
            int amount;
            if (this.fluidTick == 0 && (amount = FuelHandler.getGeneratorFuelUse(fluid = this.tank.getFluid().getFluid())) > 0 && this.tank.getFluidAmount() >= amount) {
                this.tank.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                this.currentFlux = FuelHandler.getFluxGeneratedPerTick(fluid);
                this.fluidTick = 20;
            }
            if (this.fluidTick > 0 && this.energyStorage.receiveEnergy(this.currentFlux, true) >= this.currentFlux) {
                this.energyStorage.receiveEnergy(this.currentFlux, false);
                this.isActive = true;
                --this.fluidTick;
            }
        }
        if (lastActive != this.isActive || !this.f_58857_.f_46443_ && this.isActive) {
            this.m_6596_();
        }
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        this.wireType = cableType;
        this.m_6596_();
    }

    public void removeCable(@Nullable blusunrize.immersiveengineering.api.wires.Connection connection, ConnectionPoint attachedPoint) {
        this.wireType = null;
        this.m_6596_();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (this.f_58857_.m_8055_(target.position()).m_60734_() != this.f_58857_.m_8055_(this.m_58899_()).m_60734_()) {
            return false;
        }
        return this.wireType == null && (cableType.getCategory().equals("LV") || cableType.getCategory().equals("MV"));
    }

    public BlockPos getConnectionMaster(@Nullable WireType cableType, TargetingInfo target) {
        return this.f_58858_;
    }

    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return new ConnectionPoint(this.f_58858_, 0);
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return List.of(new ConnectionPoint(this.f_58858_, 0));
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        float xo = (float)this.facing.m_122436_().m_123341_() * 0.5f + 0.5f;
        float zo = (float)this.facing.m_122436_().m_123343_() * 0.5f + 0.5f;
        return new Vec3((double)xo, 0.5, (double)zo);
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)EnergyTransferHandler.ID);
    }
}

