/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AutoLubricatorBlock
extends IPBlockBase
implements EntityBlock {
    private static final Material material = new Material(MaterialColor.f_76411_, false, false, true, true, false, false, PushReaction.BLOCK);
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SLAVE = BooleanProperty.m_61465_((String)"slave");
    static final VoxelShape SHAPE_SLAVE = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    static final VoxelShape SHAPE_MASTER = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public AutoLubricatorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56736_).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new AutoLubricatorBlockItem(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SLAVE});
    }

    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        AutoLubricatorTileEntity te = (AutoLubricatorTileEntity)((BlockEntityType)IPTileTypes.AUTOLUBE.get()).m_155264_(pPos, pState);
        te.isSlave = (Boolean)pState.m_61143_((Property)SLAVE);
        te.facing = (Direction)pState.m_61143_((Property)FACING);
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return AutoLubricatorBlock.createCommonTicker(level.f_46443_, type, IPTileTypes.AUTOLUBE);
    }

    public void m_5707_(@Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            worldIn.m_46961_(pos.m_142082_(0, -1, 0), !player.m_7500_());
        } else {
            worldIn.m_46961_(pos.m_142082_(0, 1, 0), false);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof AutoLubricatorTileEntity) {
            AutoLubricatorTileEntity autolube = (AutoLubricatorTileEntity)te;
            if ((autolube = autolube.master()) != null && autolube.interact(hit.m_82434_(), player, handIn, player.m_21120_(handIn), (float)hit.m_82450_().f_82479_, (float)hit.m_82450_().f_82480_, (float)hit.m_82450_().f_82481_)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6402_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (!worldIn.f_46443_) {
            worldIn.m_46597_(pos.m_142082_(0, 1, 0), (BlockState)state.m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof IEBlockInterfaces.IReadOnPlacement) {
                IEBlockInterfaces.IReadOnPlacement read = (IEBlockInterfaces.IReadOnPlacement)te;
                read.readOnPlacement(placer, stack);
            }
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SLAVE) != false ? SHAPE_SLAVE : SHAPE_MASTER;
    }

    public static class AutoLubricatorBlockItem
    extends IPBlockItemBase {
        public AutoLubricatorBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().m_41491_(ImmersivePetroleum.creativeTab));
        }

        protected boolean m_40610_(@Nonnull BlockPlaceContext con, @Nonnull BlockState state) {
            if (super.m_40610_(con, state)) {
                BlockPos otherPos = con.m_8083_().m_142300_(Direction.UP);
                BlockState otherState = con.m_43725_().m_8055_(otherPos);
                return otherState.m_60795_();
            }
            return false;
        }
    }
}

