/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PumpjackLubricationHandler
implements LubricatedHandler.ILubricationHandler<PumpjackTileEntity> {
    private static final Vec3i size = new Vec3i(4, 6, 3);
    private static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/lube_pipe.png");
    @OnlyIn(value=Dist.CLIENT)
    private static Supplier<IPModel> pipes_normal;
    @OnlyIn(value=Dist.CLIENT)
    private static Supplier<IPModel> pipes_mirrored;

    @Override
    public Vec3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(Level world, PumpjackTileEntity mbte) {
        return mbte.wasActive;
    }

    @Override
    public BlockEntity isPlacedCorrectly(Level world, AutoLubricatorTileEntity lubricator, Direction facing) {
        BlockPos target = lubricator.m_58899_().m_142300_(facing);
        BlockEntity te = world.m_7702_(target);
        if (te instanceof PumpjackTileEntity) {
            PumpjackTileEntity master = (PumpjackTileEntity)te;
            if ((master = (PumpjackTileEntity)master.master()) != null) {
                Direction f;
                Direction direction = f = master.getIsMirrored() ? facing : facing.m_122424_();
                if (master.getFacing().m_122427_() == f) {
                    return master;
                }
            }
        }
        return null;
    }

    @Override
    public void lubricateClient(ClientLevel world, Fluid lubricant, int ticks, PumpjackTileEntity mbte) {
        mbte.activeTicks += 0.25f;
    }

    @Override
    public void lubricateServer(ServerLevel world, Fluid lubricant, int ticks, PumpjackTileEntity mbte) {
        if (ticks % 4 == 0) {
            mbte.tickServer();
        }
    }

    @Override
    public void spawnLubricantParticles(ClientLevel world, AutoLubricatorTileEntity lubricator, Direction facing, PumpjackTileEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.m_122424_();
        float location = world.f_46441_.nextFloat();
        boolean flip = f.m_122434_() == Direction.Axis.Z ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 2.5f;
        float zO = -0.15f;
        float yO = 2.25f;
        if (location > 0.5f) {
            xO = 1.7f;
            yO = 2.9f;
            zO = -1.5f;
        }
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.m_58899_().m_123341_() + (f.m_122434_() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.m_58899_().m_123342_() + yO;
        float z = (float)lubricator.m_58899_().m_123343_() + (f.m_122434_() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.f_46441_.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.f_46441_.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.f_46441_.nextFloat();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(Level world, PumpjackTileEntity mbte) {
        if (!mbte.isDummy()) {
            Direction mbFacing = mbte.getFacing().m_122424_();
            BlockPos pos = mbte.m_58899_().m_142300_(Direction.UP).m_5484_(mbFacing, 4).m_5484_(mbte.getIsMirrored() ? mbFacing.m_122427_() : mbFacing.m_122428_(), 2);
            Direction f = (mbte.getIsMirrored() ? mbte.getFacing().m_122424_() : mbte.getFacing()).m_122428_();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, PumpjackTileEntity mbte, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IPModel model;
        matrix.m_85837_(0.0, -1.0, 0.0);
        BlockPos offset = mbte.m_58899_().m_141950_((Vec3i)lubricator.m_58899_());
        matrix.m_85837_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                matrix.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.m_85837_(-6.0, 1.0, -1.0);
                break;
            }
            case SOUTH: {
                matrix.m_85845_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                matrix.m_85837_(-5.0, 1.0, -2.0);
                break;
            }
            case EAST: {
                matrix.m_85837_(-5.0, 1.0, -1.0);
                break;
            }
            case WEST: {
                matrix.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrix.m_85837_(-6.0, 1.0, -2.0);
                break;
            }
        }
        if (mbte.getIsMirrored()) {
            if (pipes_mirrored == null) {
                pipes_mirrored = IPModels.getSupplier("pumpjack_lubepipes_mirrored");
            }
            model = pipes_mirrored.get();
        } else {
            if (pipes_normal == null) {
                pipes_normal = IPModels.getSupplier("pumpjack_lubepipes_normal");
            }
            model = pipes_normal.get();
        }
        if (model != null) {
            model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

