/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageDerrick
implements INetMessage {
    BlockPos derrickPos;
    CompoundTag nbt;

    public static void sendToServer(BlockPos derrickPos, PipeConfig.Grid grid) {
        IPPacketHandler.sendToServer(new MessageDerrick(derrickPos, grid));
    }

    private MessageDerrick(BlockPos derrick, PipeConfig.Grid grid) {
        this.derrickPos = derrick;
        this.nbt = grid.toCompound();
    }

    public MessageDerrick(FriendlyByteBuf buf) {
        this.nbt = buf.m_130260_();
        this.derrickPos = buf.m_130135_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.m_130064_(this.derrickPos);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world;
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == LogicalSide.SERVER && (world = Objects.requireNonNull(con.getSender()).m_183503_()).isAreaLoaded(this.derrickPos, 2) && (te = world.m_7702_(this.derrickPos)) instanceof DerrickTileEntity) {
                DerrickTileEntity derrick = (DerrickTileEntity)te;
                derrick.gridStorage = PipeConfig.Grid.fromCompound(this.nbt);
                derrick.updateMasterBlock(null, true);
                WellTileEntity well = derrick.getWell();
                derrick.transferGridDataToWell(well);
            }
        });
    }
}

