/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class Utils {
    static final DecimalFormat FORMATTER = new DecimalFormat("#,###.##");

    public static String fDecimal(byte number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(short number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(int number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(long number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(float number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(double number) {
        return FORMATTER.format(number);
    }

    public static void unlockIPAdvancement(Player player, String name) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerAdvancements advancements = serverPlayer.m_8960_();
            ServerAdvancementManager manager = ((ServerLevel)serverPlayer.m_20193_()).m_142572_().m_129889_();
            Advancement advancement = manager.m_136041_(ResourceUtils.ip(name));
            if (advancement != null) {
                advancements.m_135988_(advancement, "code_trigger");
            }
        }
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack) {
        Utils.dropItem(level, pos, stack, ItemEntity::m_32060_);
    }

    public static void dropItemNoDelay(Level level, BlockPos pos, ItemStack stack) {
        Utils.dropItem(level, pos, stack, ItemEntity::m_32061_);
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack, Consumer<ItemEntity> func) {
        if (!(level.f_46443_ || stack.m_41619_() || level.restoringBlockSnapshots)) {
            double f = (double)EntityType.f_20461_.m_20679_() / 2.0;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 - f;
            double z = (double)pos.m_123343_() + 0.5;
            ItemEntity entity = new ItemEntity(level, x, y, z, stack);
            func.accept(entity);
            level.m_7967_((Entity)entity);
        }
    }
}

