/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersivepetroleum/Coker")
@ZenCodeType.Name(value="mods.immersivepetroleum.CokerUnit")
public class CokerUnitRecipeTweaker
implements IRecipeManager<CokerUnitRecipe> {
    public RecipeType<CokerUnitRecipe> getRecipeType() {
        return (RecipeType)IPRecipeTypes.COKER.get();
    }

    @ZenCodeType.Method
    public void removeAll() {
        CokerUnitRecipe.recipes.clear();
    }

    @ZenCodeType.Method
    public void remove(IIngredient output) {
        CokerUnitRecipe.recipes.values().removeIf(recipe -> output.matches((IItemStack)new MCItemStack((ItemStack)recipe.outputItem.get())));
    }

    @ZenCodeType.Method
    public void remove(IFluidStack output) {
        CokerUnitRecipe.recipes.values().removeIf(recipe -> recipe.outputFluid.isFluidEqual(output.getInternal()));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack inputItem, IItemStack outputItem, Many<KnownTag<Fluid>> inputFluid, IFluidStack outputFluid, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation id = ResourceUtils.ct("cokerunit/" + name);
        FluidStack outFluid = outputFluid.getInternal();
        FluidTagInput inFluid = new FluidTagInput(((KnownTag)inputFluid.getData()).getTagKey(), inputFluid.getAmount());
        IngredientWithSize inStack = new IngredientWithSize(Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputItem.getInternal()}), inputItem.getAmount());
        Lazy outStack = Lazy.of(() -> ((IItemStack)outputItem).getInternal());
        CokerUnitRecipe recipe = new CokerUnitRecipe(id, (Lazy<ItemStack>)outStack, outFluid, inStack, inFluid, energy, 30);
        CokerUnitRecipe.recipes.put(id, recipe);
    }
}

