/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jep;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jep.Jepp;
import net.mehvahdjukaar.jep.PaintingInfoRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PaintingRecipeCategory
implements IRecipeCategory<PaintingInfoRecipe> {
    public static final ResourceLocation UID = Jepp.res("paintings");
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public PaintingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Items.f_42487_));
        this.localizedName = new TranslatableComponent("jepp.category.paintings_info");
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PaintingInfoRecipe> getRecipeClass() {
        return PaintingInfoRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(PaintingInfoRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, List.of(new ItemStack((ItemLike)Items.f_42487_)));
    }

    public void draw(PaintingInfoRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        int yPos = 117;
        Font font = Minecraft.m_91087_().f_91062_;
        BaseComponent name = recipe.getName();
        name.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        float centerX = 80.0f - (float)font.m_92852_((FormattedText)name) / 2.0f;
        font.m_92877_(matrixStack, Language.m_128107_().m_5536_((FormattedText)name), centerX, 0.0f, -16777216);
        FormattedText descriptionLine = recipe.getDescription();
        centerX = 80.0f - (float)font.m_92852_(descriptionLine) / 2.0f;
        font.m_92877_(matrixStack, Language.m_128107_().m_5536_(descriptionLine), centerX, (float)yPos, -16777216);
        Motive motive = recipe.getMotive();
        float spacing = 12.0f;
        float maxWidth = 160.0f;
        float maxHeight = 125.0f - spacing - 12.0f;
        matrixStack.m_85837_((double)(maxWidth / 2.0f), (double)(spacing + maxHeight / 2.0f), 0.0);
        int pWidth = motive.m_31896_();
        int pHeight = motive.m_31901_();
        float ratio = (float)pHeight / (float)pWidth;
        float screenRatio = maxHeight / maxWidth;
        float scale = ratio < screenRatio ? maxWidth / (float)pWidth : maxHeight / (float)pHeight;
        matrixStack.m_85841_(scale, scale, scale);
        ResourceLocation texture = Minecraft.m_91087_().m_91305_().m_118806_().m_118414_().m_118330_();
        PaintingTextureManager paintingtexturemanager = Minecraft.m_91087_().m_91305_();
        TextureAtlasSprite sprite = paintingtexturemanager.m_118804_(motive);
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        matrixStack.m_85837_((double)((float)(-pWidth) / 2.0f), (double)((float)(-pHeight) / 2.0f), 0.0);
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)0, (int)0, (int)0, (int)pWidth, (int)pHeight, (TextureAtlasSprite)sprite);
        RenderSystem.m_157182_();
    }

    public void setRecipe(IRecipeLayout recipeLayout, PaintingInfoRecipe recipe, IIngredients ingredients) {
    }
}

