/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class InfusedFarmlandBlock
extends FarmBlock
implements IColored,
IEssenceFarmland {
    public static final List<InfusedFarmlandBlock> FARMLANDS = new ArrayList<InfusedFarmlandBlock>();
    private final CropTier tier;

    public InfusedFarmlandBlock(CropTier tier) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_));
        this.tier = tier;
        FARMLANDS.add(this);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_142300_(direction));
        return type == PlantType.CROP || type == PlantType.PLAINS;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 1.0f, DamageSource.f_19315_);
    }

    public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)f_53243_) > 0;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        if (!InfusedFarmlandBlock.m_53258_((LevelReader)world, (BlockPos)pos) && !world.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
        if (stack != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0) {
            drops.add(new ItemStack((ItemLike)this));
        } else {
            drops.add(new ItemStack((ItemLike)Blocks.f_50493_));
            if (builder.m_78962_().m_5822_().nextInt(100) < 25) {
                drops.add(new ItemStack((ItemLike)this.tier.getEssence(), 1));
            }
        }
        return drops;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TIER.args(new Object[]{this.tier.getDisplayName()}).build());
    }

    public int getColor(int index) {
        return this.tier.getColor();
    }

    @Override
    public CropTier getTier() {
        return this.tier;
    }
}

