/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.appliedcooking.api.cookingforblockheads.capability;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.MachineSource;
import dev.smolinacadena.appliedcooking.blockentity.KitchenStationBlockEntity;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.minecraft.world.item.ItemStack;

public class KitchenItemProvider
implements IKitchenItemProvider {
    private final KitchenStationBlockEntity blockEntity;
    private final HashMap<String, Integer> usedStackSizes;

    public KitchenItemProvider(KitchenStationBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.usedStackSizes = new HashMap();
    }

    public MEStorage getNetworkStorage() {
        return this.blockEntity.getNetworkStorage();
    }

    public void resetSimulation() {
        this.usedStackSizes.replaceAll((n, v) -> 0);
    }

    public int getSimulatedUseCount(int slot) {
        return 0;
    }

    public int getSimulatedUseCount(String key) {
        return this.usedStackSizes.getOrDefault(key, 0);
    }

    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        return ItemStack.f_41583_;
    }

    public void useItemStack(ItemStack itemStack, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        String itemRegistryName = itemStack.m_41720_().getRegistryName().toString();
        if (itemStack.m_41613_() - (simulate ? this.usedStackSizes.getOrDefault(itemRegistryName, 0) : 0) >= amount) {
            long result = this.getNetworkStorage().extract((AEKey)AEItemKey.of((ItemStack)itemStack), (long)amount, simulate ? Actionable.SIMULATE : Actionable.MODULATE, (IActionSource)new MachineSource(this.blockEntity.getActionHost()));
            if (simulate && result > 0L) {
                this.usedStackSizes.put(itemRegistryName, this.usedStackSizes.getOrDefault(itemRegistryName, 0) + (int)result);
            }
        }
    }

    public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
        long insertResult = this.getNetworkStorage().insert((AEKey)AEItemKey.of((ItemStack)itemStack), (long)itemStack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource(this.blockEntity.getActionHost()));
        if (insertResult > 0L) {
            itemStack.m_41764_(itemStack.m_41613_() - (int)insertResult);
        }
        return itemStack;
    }

    public int getSlots() {
        return this.getNetworkStorage() != null ? this.getNetworkStorage().getAvailableStacks().size() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack returnItemStack(ItemStack itemStack) {
        return itemStack;
    }

    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        if (this.getNetworkStorage() != null && predicate instanceof IngredientPredicateWithCache) {
            IngredientPredicateWithCache predicateWithItems = (IngredientPredicateWithCache)predicate;
            for (ItemStack ingredient : predicateWithItems.getItems()) {
                AEItemKey ingredientKey = AEItemKey.of((ItemStack)ingredient);
                long ingredientAmount = this.getNetworkStorage().getAvailableStacks().get((AEKey)ingredientKey);
                if (ingredientAmount <= 0L || !predicate.test(ingredientKey.toStack((int)ingredientAmount), (int)ingredientAmount - this.getSimulatedUseCount(ingredient.m_41778_()))) continue;
                return new SourceItem((IKitchenItemProvider)this, 0, ingredientKey.toStack((int)ingredientAmount).m_41777_());
            }
        }
        return null;
    }

    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        SourceItem sourceItem = this.findSource(predicate, maxAmount, inventories, requireBucket, simulate);
        if (sourceItem != null) {
            this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().m_41613_(), maxAmount), simulate, inventories, requireBucket);
        }
        return sourceItem;
    }

    public void consumeSourceItem(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireContainer) {
        if (sourceItem.getSourceSlot() < 0) {
            return;
        }
        this.useItemStack(sourceItem.getSourceStack(), maxAmount, false, inventories, requireContainer);
    }

    public void markAsUsed(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().m_41613_(), maxAmount), true, inventories, requireBucket);
    }
}

