/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularAccumulatorDisplaySource
extends PercentOrProgressBarDisplaySource {
    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        int mode = this.getMode(context);
        if (mode == 1) {
            return super.formatNumeric(context, currentLevel);
        }
        return Util.getTextComponent(Math.round(currentLevel.floatValue()), "fe");
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().m_128451_("Mode");
    }

    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof ModularAccumulatorBlockEntity)) {
            return null;
        }
        ModularAccumulatorBlockEntity te = (ModularAccumulatorBlockEntity)blockEntity;
        te = te.getControllerBE();
        if (te == null) {
            return null;
        }
        float capacity = te.energyStorage.getMaxEnergyStored();
        float stored = te.energyStorage.getEnergyStored();
        if (capacity == 0.0f) {
            return Float.valueOf(0.0f);
        }
        return switch (this.getMode(context)) {
            case 0, 1 -> Float.valueOf(stored / capacity);
            case 2 -> Float.valueOf(stored);
            case 3 -> Float.valueOf(capacity);
            case 4 -> Float.valueOf(capacity - stored);
            default -> Float.valueOf(0.0f);
        };
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(List.of(new TranslatableComponent("createaddition.display_source.accumulator.progress_bar"), new TranslatableComponent("createaddition.display_source.accumulator.percent"), new TranslatableComponent("createaddition.display_source.accumulator.current"), new TranslatableComponent("createaddition.display_source.accumulator.max"), new TranslatableComponent("createaddition.display_source.accumulator.remaining"))).titled((MutableComponent)new TranslatableComponent("createaddition.display_source.accumulator.display")), "Mode");
    }

    protected String getTranslationKey() {
        return "modular_accumulator";
    }
}

