/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LabelGunWorldRenderer {
    private static final int BUFFER_SIZE = 256;
    private static final RenderType RENDER_TYPE = RenderType.m_173215_((String)"sfmlabels", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, false)).m_110663_(new RenderStateShard.DepthTestStateShard("always", 519)).m_110685_(new RenderStateShard.TransparencyStateShard("src_to_one", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    })).m_110691_(true));

    @SubscribeEvent
    public static void renderLabelHighlights(RenderLevelLastEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack labelGun = player.m_21205_();
        if (!(labelGun.m_41720_() instanceof LabelGunItem)) {
            labelGun = player.m_21206_();
        }
        if (!(labelGun.m_41720_() instanceof LabelGunItem)) {
            return;
        }
        Vec3 playerPosition = player.m_20182_();
        Multimap<BlockPos, String> labelPositions = SFMLabelNBTHelper.getPositionLabels(labelGun);
        PoseStack poseStack = event.getPoseStack();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69465_();
        poseStack.m_85836_();
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        for (Map.Entry entry : labelPositions.asMap().entrySet()) {
            LabelGunWorldRenderer.drawLabel(poseStack, camera, (BlockPos)entry.getKey(), (MultiBufferSource)bufferSource, (Collection)entry.getValue());
        }
        RENDER_TYPE.m_110185_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69472_();
        VertexBuffer vbo = LabelGunWorldRenderer.createVBO(new PoseStack(), camera, labelPositions.keySet());
        vbo.m_166867_(poseStack.m_85850_().m_85861_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
        RENDER_TYPE.m_110188_();
        RenderSystem.m_69493_();
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_69482_();
    }

    private static void drawLabel(PoseStack poseStack, Camera camera, BlockPos pos, MultiBufferSource mbs, Collection<String> labels) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        poseStack.m_85845_(camera.m_90591_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.m_91087_().f_91062_;
        double d = labels.size();
        Objects.requireNonNull(font);
        poseStack.m_85837_(0.0, d * (9.0 + 0.1) / -2.0, 0.0);
        for (String label : labels) {
            font.m_92811_(label, (float)(-font.m_92895_(label)) / 2.0f, 0.0f, -1, false, poseStack.m_85850_().m_85861_(), mbs, true, 0, 0xF000F0);
            Objects.requireNonNull(font);
            poseStack.m_85837_(0.0, 9.0 + 0.1, 0.0);
        }
        poseStack.m_85849_();
    }

    private static VertexBuffer createVBO(PoseStack poseStack, Camera camera, Collection<BlockPos> positions) {
        BufferBuilder builder = new BufferBuilder(RENDER_TYPE.m_110507_() * positions.size());
        builder.m_166779_(RENDER_TYPE.m_173186_(), RENDER_TYPE.m_110508_());
        for (BlockPos pos : positions) {
            LabelGunWorldRenderer.drawBlockOutline(pos, poseStack, (VertexConsumer)builder, 100, 0, 255, 100);
        }
        builder.m_85721_();
        VertexBuffer vert = new VertexBuffer();
        vert.m_85925_(builder);
        return vert;
    }

    private static void drawBlockOutline(BlockPos pos, PoseStack poseStack, VertexConsumer buf, int r, int g, int b, int a) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        buf.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_6122_(r, g, b, a).m_5752_();
        buf.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_5752_();
        poseStack.m_85849_();
    }
}

