/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LabelGunItem
extends Item {
    public LabelGunItem() {
        super(new Item.Properties().m_41491_(SFMItems.TAB));
    }

    public static void setLabel(ItemStack stack, String label) {
        stack.m_41784_().m_128359_("sfm:label", label);
    }

    public static String getLabel(ItemStack stack) {
        return !stack.m_41782_() ? "" : stack.m_41783_().m_128461_("sfm:label");
    }

    public static String getNextLabel(ItemStack gun, int change) {
        CompoundTag dict = gun.m_41784_().m_128469_("sfm:labels");
        String[] keys = (String[])dict.m_128431_().toArray(String[]::new);
        if (keys.length == 0) {
            return "";
        }
        String currentLabel = LabelGunItem.getLabel(gun);
        int currentLabelIndex = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].equals(currentLabel)) continue;
            currentLabelIndex = i;
            break;
        }
        int nextLabelIndex = currentLabelIndex + change;
        nextLabelIndex = (nextLabelIndex % keys.length + keys.length) % keys.length;
        return keys[nextLabelIndex];
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ManagerBlockEntity) {
            ManagerBlockEntity manager = (ManagerBlockEntity)blockEntity;
            manager.getDisk().ifPresent(disk -> {
                if (ctx.m_43723_().m_6144_()) {
                    SFMLabelNBTHelper.copyLabels(disk, stack);
                    Set<String> scriptLabels = manager.getReferencedLabels();
                    SFMLabelNBTHelper.addLabels(stack, scriptLabels);
                    ctx.m_43723_().m_6352_((Component)new TranslatableComponent("chat.sfm.labelgun.pull"), Util.f_137441_);
                } else {
                    SFMLabelNBTHelper.copyLabels(stack, disk);
                    manager.m_6596_();
                    ctx.m_43723_().m_6352_((Component)new TranslatableComponent("chat.sfm.labelgun.push"), Util.f_137441_);
                }
            });
            return InteractionResult.CONSUME;
        }
        String label = LabelGunItem.getLabel(stack);
        if (label.isEmpty()) {
            return InteractionResult.SUCCESS;
        }
        if (ctx.m_43723_().m_6144_()) {
            SFMLabelNBTHelper.clearLabels(stack, pos);
        } else {
            SFMLabelNBTHelper.toggleLabel(stack, label, pos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        lines.add((Component)new TranslatableComponent("item.sfm.labelgun.tooltip.1").m_130940_(ChatFormatting.GRAY));
        lines.add((Component)new TranslatableComponent("item.sfm.labelgun.tooltip.2").m_130940_(ChatFormatting.GRAY));
        lines.addAll(SFMLabelNBTHelper.getHoverText(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            ClientStuff.showLabelGunScreen(stack, hand);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        String name = LabelGunItem.getLabel(stack);
        if (name.isEmpty()) {
            return super.m_7626_(stack);
        }
        return new TranslatableComponent("item.sfm.labelgun.with_label", new Object[]{name}).m_130940_(ChatFormatting.AQUA);
    }
}

