/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfml.ast.Label;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SFMLabelNBTHelper {
    public static void toggleLabel(ItemStack stack, String label, BlockPos pos) {
        if (SFMLabelNBTHelper.hasLabel(stack, label, pos)) {
            SFMLabelNBTHelper.removeLabel(stack, label, pos);
        } else {
            SFMLabelNBTHelper.addLabel(stack, label, pos);
        }
    }

    public static boolean hasLabel(ItemStack stack, String label, BlockPos pos) {
        return SFMLabelNBTHelper.getLabelDict(stack).m_128437_(label, 4).contains((Object)LongTag.m_128882_((long)pos.m_121878_()));
    }

    public static void addLabel(ItemStack stack, String label, BlockPos position) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag dict = tag.m_128469_("sfm:labels");
        ListTag list = dict.m_128437_(label, 4);
        list.add((Object)LongTag.m_128882_((long)position.m_121878_()));
        dict.m_128365_(label, (Tag)list);
        tag.m_128365_("sfm:labels", (Tag)dict);
    }

    public static void addLabels(ItemStack stack, Collection<String> labels) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag dict = tag.m_128469_("sfm:labels");
        for (String label : labels) {
            ListTag list = dict.m_128437_(label, 4);
            dict.m_128365_(label, (Tag)list);
        }
        tag.m_128365_("sfm:labels", (Tag)dict);
    }

    public static void removeLabel(ItemStack stack, String label, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag dict = tag.m_128469_("sfm:labels");
        ListTag list = dict.m_128437_(label, 4);
        list.removeIf(arg_0 -> ((LongTag)LongTag.m_128882_((long)pos.m_121878_())).equals(arg_0));
        dict.m_128365_(label, (Tag)list);
        tag.m_128365_("sfm:labels", (Tag)dict);
    }

    public static List<Component> getHoverText(ItemStack stack) {
        ArrayList<Component> rtn = new ArrayList<Component>();
        rtn.add((Component)new TranslatableComponent("item.sfm.disk.tooltip.label.header").m_130940_(ChatFormatting.UNDERLINE));
        CompoundTag dict = SFMLabelNBTHelper.getLabelDict(stack);
        for (String label : dict.m_128431_()) {
            rtn.add((Component)new TranslatableComponent("item.sfm.disk.tooltip.label", new Object[]{label, dict.m_128437_(label, 4).size()}).m_130940_(ChatFormatting.GRAY));
        }
        return rtn;
    }

    public static Stream<BlockPos> getLabelPositions(ItemStack stack, String label) {
        CompoundTag dict = SFMLabelNBTHelper.getLabelDict(stack);
        return SFMLabelNBTHelper.getPositions(dict, label);
    }

    public static Stream<BlockPos> getPositions(ItemStack stack, List<Label> labels) {
        CompoundTag dict = SFMLabelNBTHelper.getLabelDict(stack);
        return labels.stream().map(Label::name).flatMap(label -> SFMLabelNBTHelper.getPositions(dict, label)).distinct();
    }

    private static Stream<BlockPos> getPositions(CompoundTag tag, String label) {
        return tag.m_128437_(label, 4).stream().map(LongTag.class::cast).mapToLong(LongTag::m_7046_).mapToObj(BlockPos::m_122022_);
    }

    public static Multimap<BlockPos, String> getPositionLabels(ItemStack stack) {
        HashMultimap rtn = HashMultimap.create();
        CompoundTag dict = SFMLabelNBTHelper.getLabelDict(stack);
        for (String key : dict.m_128431_()) {
            SFMLabelNBTHelper.getPositions(dict, key).forEach(pos -> rtn.put(pos, (Object)key));
        }
        return rtn;
    }

    @NotNull
    private static CompoundTag getLabelDict(ItemStack stack) {
        return stack.m_41784_().m_128469_("sfm:labels");
    }

    public static void copyLabels(ItemStack source, ItemStack destination) {
        destination.m_41784_().m_128365_("sfm:labels", (Tag)SFMLabelNBTHelper.getLabelDict(source));
    }

    public static void clearLabels(ItemStack gun, BlockPos pos) {
        CompoundTag dict = SFMLabelNBTHelper.getLabelDict(gun);
        for (String key : dict.m_128431_()) {
            dict.m_128437_(key, 4).removeIf(p -> ((LongTag)p).m_7046_() == pos.m_121878_());
        }
    }
}

