/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.ItemIdentifier;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Quantity;
import ca.teamdman.sfml.ast.SetOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public record ItemComparer(ComparisonOperator op, Quantity num, ItemIdentifier item) implements ASTNode
{
    public static BoolExpr toBooleanExpression(SetOperator setOp, LabelAccess labelAccess, ItemComparer itemComparer) {
        return new BoolExpr(context -> {
            Stream<IItemHandler> handlers = context.getItemHandlersByLabels(labelAccess);
            int overallCount = 0;
            ArrayList<Boolean> satisfied = new ArrayList<Boolean>();
            for (IItemHandler inv : handlers::iterator) {
                int invCount = 0;
                for (int slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack stack;
                    if (!labelAccess.slots().contains(slot) || !itemComparer.item.test(stack = inv.getStackInSlot(slot))) continue;
                    invCount += stack.m_41613_();
                    overallCount += stack.m_41613_();
                }
                satisfied.add(itemComparer.op.test(invCount, itemComparer.num.value()));
            }
            boolean overall = itemComparer.op.test(overallCount, itemComparer.num.value());
            return setOp.test(overall, (List<Boolean>)satisfied);
        });
    }
}

