/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.DetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.shared.command.arguments.ArgumentSerializers;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.generic.data.BlockData;
import dan200.computercraft.shared.peripheral.generic.data.FluidData;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.peripheral.generic.methods.EnergyMethods;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.ItemBlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.TileWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.peripheral.speaker.BlockSpeaker;
import dan200.computercraft.shared.peripheral.speaker.TileSpeaker;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.turtle.upgrades.TurtleToolSerialiser;
import dan200.computercraft.shared.util.CreativeTabMain;
import dan200.computercraft.shared.util.FixedPointTileEntityType;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="computercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    private static final CreativeModeTab mainItemGroup = new CreativeTabMain();

    private Registry() {
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        Class<TurtleUpgradeSerialiser> turtleType = TurtleUpgradeSerialiser.class;
        event.create(new RegistryBuilder().setName(TurtleUpgradeSerialiser.REGISTRY_ID.m_135782_()).setType(turtleType).disableSaving().disableSync());
        Class<PocketUpgradeSerialiser> pocketType = PocketUpgradeSerialiser.class;
        event.create(new RegistryBuilder().setName(PocketUpgradeSerialiser.REGISTRY_ID.m_135782_()).setType(pocketType).disableSaving().disableSync());
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new RecipeSerializer[]{(RecipeSerializer)ColourableRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "colour")), (RecipeSerializer)ComputerUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "computer_upgrade")), (RecipeSerializer)PocketComputerUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "pocket_computer_upgrade")), (RecipeSerializer)DiskRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "disk")), (RecipeSerializer)PrintoutRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "printout")), (RecipeSerializer)TurtleRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "turtle")), (RecipeSerializer)TurtleUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "turtle_upgrade")), (RecipeSerializer)ImpostorShapelessRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "impostor_shapeless")), (RecipeSerializer)ImpostorRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "impostor_shaped"))});
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IWiredElement.class);
        event.register(IPeripheral.class);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkHandler.setup();
        event.enqueueWork(() -> {
            Registry.registerProviders();
            ArgumentSerializers.register();
            Registry.registerLoot();
        });
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        ComputerCraftAPI.registerGenericSource(new FluidMethods());
        ComputerCraftAPI.registerGenericSource(new EnergyMethods());
    }

    private static void registerProviders() {
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item item = stack.m_41720_();
            if (item instanceof IMedia) {
                IMedia media = (IMedia)item;
                return media;
            }
            if (item instanceof RecordItem) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        ComputerCraftAPI.registerGenericCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        ComputerCraftAPI.registerGenericCapability(CapabilityEnergy.ENERGY);
        ComputerCraftAPI.registerGenericCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        DetailRegistries.ITEM_STACK.addProvider(ItemData::fill);
        DetailRegistries.BLOCK_IN_WORLD.addProvider(BlockData::fill);
        DetailRegistries.FLUID_STACK.addProvider(FluidData::fill);
        CauldronInteraction.f_175607_.put((Item)ModItems.TURTLE_NORMAL.get(), ItemTurtle.CAULDRON_INTERACTION);
        CauldronInteraction.f_175607_.put((Item)ModItems.TURTLE_ADVANCED.get(), ItemTurtle.CAULDRON_INTERACTION);
    }

    public static void registerLoot() {
        Registry.registerCondition("block_named", BlockNamedEntityLootCondition.TYPE);
        Registry.registerCondition("player_creative", PlayerCreativeLootCondition.TYPE);
        Registry.registerCondition("has_id", HasComputerIdLootCondition.TYPE);
    }

    private static void registerCondition(String name, LootItemConditionType serializer) {
        net.minecraft.core.Registry.m_122965_((net.minecraft.core.Registry)net.minecraft.core.Registry.f_122877_, (ResourceLocation)new ResourceLocation("computercraft", name), (Object)serializer);
    }

    public static void setup() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(bus);
        ModBlockEntities.TILES.register(bus);
        ModItems.ITEMS.register(bus);
        ModTurtleSerialisers.SERIALISERS.register(bus);
        ModPocketUpgradeSerialisers.SERIALISERS.register(bus);
        ModContainers.CONTAINERS.register(bus);
    }

    public static final class ModItems {
        static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"computercraft");
        public static final RegistryObject<ItemComputer> COMPUTER_NORMAL = ModItems.ofBlock(ModBlocks.COMPUTER_NORMAL, ItemComputer::new);
        public static final RegistryObject<ItemComputer> COMPUTER_ADVANCED = ModItems.ofBlock(ModBlocks.COMPUTER_ADVANCED, ItemComputer::new);
        public static final RegistryObject<ItemComputer> COMPUTER_COMMAND = ModItems.ofBlock(ModBlocks.COMPUTER_COMMAND, ItemComputer::new);
        public static final RegistryObject<ItemPocketComputer> POCKET_COMPUTER_NORMAL = ITEMS.register("pocket_computer_normal", () -> new ItemPocketComputer(ModItems.properties().m_41487_(1), ComputerFamily.NORMAL));
        public static final RegistryObject<ItemPocketComputer> POCKET_COMPUTER_ADVANCED = ITEMS.register("pocket_computer_advanced", () -> new ItemPocketComputer(ModItems.properties().m_41487_(1), ComputerFamily.ADVANCED));
        public static final RegistryObject<ItemTurtle> TURTLE_NORMAL = ModItems.ofBlock(ModBlocks.TURTLE_NORMAL, ItemTurtle::new);
        public static final RegistryObject<ItemTurtle> TURTLE_ADVANCED = ModItems.ofBlock(ModBlocks.TURTLE_ADVANCED, ItemTurtle::new);
        public static final RegistryObject<ItemDisk> DISK = ITEMS.register("disk", () -> new ItemDisk(ModItems.properties().m_41487_(1)));
        public static final RegistryObject<ItemTreasureDisk> TREASURE_DISK = ITEMS.register("treasure_disk", () -> new ItemTreasureDisk(ModItems.properties().m_41487_(1)));
        public static final RegistryObject<ItemPrintout> PRINTED_PAGE = ITEMS.register("printed_page", () -> new ItemPrintout(ModItems.properties().m_41487_(1), ItemPrintout.Type.PAGE));
        public static final RegistryObject<ItemPrintout> PRINTED_PAGES = ITEMS.register("printed_pages", () -> new ItemPrintout(ModItems.properties().m_41487_(1), ItemPrintout.Type.PAGES));
        public static final RegistryObject<ItemPrintout> PRINTED_BOOK = ITEMS.register("printed_book", () -> new ItemPrintout(ModItems.properties().m_41487_(1), ItemPrintout.Type.BOOK));
        public static final RegistryObject<BlockItem> SPEAKER = ModItems.ofBlock(ModBlocks.SPEAKER, BlockItem::new);
        public static final RegistryObject<BlockItem> DISK_DRIVE = ModItems.ofBlock(ModBlocks.DISK_DRIVE, BlockItem::new);
        public static final RegistryObject<BlockItem> PRINTER = ModItems.ofBlock(ModBlocks.PRINTER, BlockItem::new);
        public static final RegistryObject<BlockItem> MONITOR_NORMAL = ModItems.ofBlock(ModBlocks.MONITOR_NORMAL, BlockItem::new);
        public static final RegistryObject<BlockItem> MONITOR_ADVANCED = ModItems.ofBlock(ModBlocks.MONITOR_ADVANCED, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRELESS_MODEM_NORMAL = ModItems.ofBlock(ModBlocks.WIRELESS_MODEM_NORMAL, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRELESS_MODEM_ADVANCED = ModItems.ofBlock(ModBlocks.WIRELESS_MODEM_ADVANCED, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRED_MODEM_FULL = ModItems.ofBlock(ModBlocks.WIRED_MODEM_FULL, BlockItem::new);
        public static final RegistryObject<ItemBlockCable.Cable> CABLE = ITEMS.register("cable", () -> new ItemBlockCable.Cable((BlockCable)((Object)((Object)ModBlocks.CABLE.get())), ModItems.properties()));
        public static final RegistryObject<ItemBlockCable.WiredModem> WIRED_MODEM = ITEMS.register("wired_modem", () -> new ItemBlockCable.WiredModem((BlockCable)((Object)((Object)ModBlocks.CABLE.get())), ModItems.properties()));

        private static Item.Properties properties() {
            return new Item.Properties().m_41491_(mainItemGroup);
        }

        private static <B extends Block, I extends Item> RegistryObject<I> ofBlock(RegistryObject<B> parent, BiFunction<B, Item.Properties, I> supplier) {
            return ITEMS.register(parent.getId().m_135815_(), () -> (Item)supplier.apply((Block)parent.get(), ModItems.properties()));
        }
    }

    public static final class ModBlocks {
        static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"computercraft");
        public static final RegistryObject<BlockComputer<TileComputer>> COMPUTER_NORMAL = BLOCKS.register("computer_normal", () -> new BlockComputer<TileComputer>(ModBlocks.properties(), ComputerFamily.NORMAL, ModBlockEntities.COMPUTER_NORMAL));
        public static final RegistryObject<BlockComputer<TileComputer>> COMPUTER_ADVANCED = BLOCKS.register("computer_advanced", () -> new BlockComputer<TileComputer>(ModBlocks.properties(), ComputerFamily.ADVANCED, ModBlockEntities.COMPUTER_ADVANCED));
        public static final RegistryObject<BlockComputer<TileCommandComputer>> COMPUTER_COMMAND = BLOCKS.register("computer_command", () -> new BlockComputer<TileCommandComputer>(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 6000000.0f), ComputerFamily.COMMAND, ModBlockEntities.COMPUTER_COMMAND));
        public static final RegistryObject<BlockTurtle> TURTLE_NORMAL = BLOCKS.register("turtle_normal", () -> new BlockTurtle(ModBlocks.turtleProperties(), ComputerFamily.NORMAL, ModBlockEntities.TURTLE_NORMAL));
        public static final RegistryObject<BlockTurtle> TURTLE_ADVANCED = BLOCKS.register("turtle_advanced", () -> new BlockTurtle(ModBlocks.turtleProperties(), ComputerFamily.ADVANCED, ModBlockEntities.TURTLE_ADVANCED));
        public static final RegistryObject<BlockSpeaker> SPEAKER = BLOCKS.register("speaker", () -> new BlockSpeaker(ModBlocks.properties()));
        public static final RegistryObject<BlockDiskDrive> DISK_DRIVE = BLOCKS.register("disk_drive", () -> new BlockDiskDrive(ModBlocks.properties()));
        public static final RegistryObject<BlockPrinter> PRINTER = BLOCKS.register("printer", () -> new BlockPrinter(ModBlocks.properties()));
        public static final RegistryObject<BlockMonitor> MONITOR_NORMAL = BLOCKS.register("monitor_normal", () -> new BlockMonitor(ModBlocks.properties(), (RegistryObject<? extends BlockEntityType<? extends TileMonitor>>)ModBlockEntities.MONITOR_NORMAL));
        public static final RegistryObject<BlockMonitor> MONITOR_ADVANCED = BLOCKS.register("monitor_advanced", () -> new BlockMonitor(ModBlocks.properties(), (RegistryObject<? extends BlockEntityType<? extends TileMonitor>>)ModBlockEntities.MONITOR_ADVANCED));
        public static final RegistryObject<BlockWirelessModem> WIRELESS_MODEM_NORMAL = BLOCKS.register("wireless_modem_normal", () -> new BlockWirelessModem(ModBlocks.properties(), (RegistryObject<? extends BlockEntityType<? extends TileWirelessModem>>)ModBlockEntities.WIRELESS_MODEM_NORMAL));
        public static final RegistryObject<BlockWirelessModem> WIRELESS_MODEM_ADVANCED = BLOCKS.register("wireless_modem_advanced", () -> new BlockWirelessModem(ModBlocks.properties(), (RegistryObject<? extends BlockEntityType<? extends TileWirelessModem>>)ModBlockEntities.WIRELESS_MODEM_ADVANCED));
        public static final RegistryObject<BlockWiredModemFull> WIRED_MODEM_FULL = BLOCKS.register("wired_modem_full", () -> new BlockWiredModemFull(ModBlocks.modemProperties()));
        public static final RegistryObject<BlockCable> CABLE = BLOCKS.register("cable", () -> new BlockCable(ModBlocks.modemProperties()));

        private static BlockBehaviour.Properties properties() {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.0f);
        }

        private static BlockBehaviour.Properties turtleProperties() {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.5f);
        }

        private static BlockBehaviour.Properties modemProperties() {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f);
        }
    }

    public static class ModBlockEntities {
        static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"computercraft");
        public static final RegistryObject<BlockEntityType<TileMonitor>> MONITOR_NORMAL = ModBlockEntities.ofBlock(ModBlocks.MONITOR_NORMAL, (f, p, s) -> new TileMonitor((BlockEntityType<? extends TileMonitor>)f, p, s, false));
        public static final RegistryObject<BlockEntityType<TileMonitor>> MONITOR_ADVANCED = ModBlockEntities.ofBlock(ModBlocks.MONITOR_ADVANCED, (f, p, s) -> new TileMonitor((BlockEntityType<? extends TileMonitor>)f, p, s, true));
        public static final RegistryObject<BlockEntityType<TileComputer>> COMPUTER_NORMAL = ModBlockEntities.ofBlock(ModBlocks.COMPUTER_NORMAL, (f, p, s) -> new TileComputer((BlockEntityType<? extends TileComputer>)f, p, s, ComputerFamily.NORMAL));
        public static final RegistryObject<BlockEntityType<TileComputer>> COMPUTER_ADVANCED = ModBlockEntities.ofBlock(ModBlocks.COMPUTER_ADVANCED, (f, p, s) -> new TileComputer((BlockEntityType<? extends TileComputer>)f, p, s, ComputerFamily.ADVANCED));
        public static final RegistryObject<BlockEntityType<TileCommandComputer>> COMPUTER_COMMAND = ModBlockEntities.ofBlock(ModBlocks.COMPUTER_COMMAND, TileCommandComputer::new);
        public static final RegistryObject<BlockEntityType<TileTurtle>> TURTLE_NORMAL = ModBlockEntities.ofBlock(ModBlocks.TURTLE_NORMAL, (f, p, s) -> new TileTurtle((BlockEntityType<? extends TileGeneric>)f, p, s, ComputerFamily.NORMAL));
        public static final RegistryObject<BlockEntityType<TileTurtle>> TURTLE_ADVANCED = ModBlockEntities.ofBlock(ModBlocks.TURTLE_ADVANCED, (f, p, s) -> new TileTurtle((BlockEntityType<? extends TileGeneric>)f, p, s, ComputerFamily.ADVANCED));
        public static final RegistryObject<BlockEntityType<TileSpeaker>> SPEAKER = ModBlockEntities.ofBlock(ModBlocks.SPEAKER, TileSpeaker::new);
        public static final RegistryObject<BlockEntityType<TileDiskDrive>> DISK_DRIVE = ModBlockEntities.ofBlock(ModBlocks.DISK_DRIVE, TileDiskDrive::new);
        public static final RegistryObject<BlockEntityType<TilePrinter>> PRINTER = ModBlockEntities.ofBlock(ModBlocks.PRINTER, TilePrinter::new);
        public static final RegistryObject<BlockEntityType<TileWiredModemFull>> WIRED_MODEM_FULL = ModBlockEntities.ofBlock(ModBlocks.WIRED_MODEM_FULL, TileWiredModemFull::new);
        public static final RegistryObject<BlockEntityType<TileCable>> CABLE = ModBlockEntities.ofBlock(ModBlocks.CABLE, TileCable::new);
        public static final RegistryObject<BlockEntityType<TileWirelessModem>> WIRELESS_MODEM_NORMAL = ModBlockEntities.ofBlock(ModBlocks.WIRELESS_MODEM_NORMAL, (f, p, s) -> new TileWirelessModem((BlockEntityType<? extends TileWirelessModem>)f, p, s, false));
        public static final RegistryObject<BlockEntityType<TileWirelessModem>> WIRELESS_MODEM_ADVANCED = ModBlockEntities.ofBlock(ModBlocks.WIRELESS_MODEM_ADVANCED, (f, p, s) -> new TileWirelessModem((BlockEntityType<? extends TileWirelessModem>)f, p, s, true));

        private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> ofBlock(RegistryObject<? extends Block> block, FixedPointTileEntityType.FixedPointBlockEntitySupplier<T> factory) {
            return TILES.register(block.getId().m_135815_(), () -> FixedPointTileEntityType.create((Supplier<? extends Block>)block, factory));
        }
    }

    public static class ModTurtleSerialisers {
        static final DeferredRegister<TurtleUpgradeSerialiser<?>> SERIALISERS = DeferredRegister.create((ResourceLocation)TurtleUpgradeSerialiser.REGISTRY_ID.m_135782_(), (String)"computercraft");
        public static final RegistryObject<TurtleUpgradeSerialiser<TurtleSpeaker>> SPEAKER = SERIALISERS.register("speaker", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleSpeaker::new));
        public static final RegistryObject<TurtleUpgradeSerialiser<TurtleCraftingTable>> WORKBENCH = SERIALISERS.register("workbench", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleCraftingTable::new));
        public static final RegistryObject<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_NORMAL = SERIALISERS.register("wireless_modem_normal", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((ResourceLocation)id, (ItemStack)item, false)));
        public static final RegistryObject<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_ADVANCED = SERIALISERS.register("wireless_modem_advanced", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((ResourceLocation)id, (ItemStack)item, true)));
        public static final RegistryObject<TurtleUpgradeSerialiser<TurtleTool>> TOOL = SERIALISERS.register("tool", () -> TurtleToolSerialiser.INSTANCE);
    }

    public static class ModPocketUpgradeSerialisers {
        static final DeferredRegister<PocketUpgradeSerialiser<?>> SERIALISERS = DeferredRegister.create(PocketUpgradeSerialiser.REGISTRY_ID, (String)"computercraft");
        public static final RegistryObject<PocketUpgradeSerialiser<PocketSpeaker>> SPEAKER = SERIALISERS.register("speaker", () -> PocketUpgradeSerialiser.simpleWithCustomItem(PocketSpeaker::new));
        public static final RegistryObject<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_NORMAL = SERIALISERS.register("wireless_modem_normal", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((ResourceLocation)id, (ItemStack)item, false)));
        public static final RegistryObject<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_ADVANCED = SERIALISERS.register("wireless_modem_advanced", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((ResourceLocation)id, (ItemStack)item, true)));
    }

    public static class ModContainers {
        static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"computercraft");
        public static final RegistryObject<MenuType<ContainerComputerBase>> COMPUTER = CONTAINERS.register("computer", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<MenuType<ContainerComputerBase>> POCKET_COMPUTER = CONTAINERS.register("pocket_computer", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<MenuType<ContainerComputerBase>> POCKET_COMPUTER_NO_TERM = CONTAINERS.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<MenuType<ContainerTurtle>> TURTLE = CONTAINERS.register("turtle", () -> ContainerData.toType(ComputerContainerData::new, ContainerTurtle::ofMenuData));
        public static final RegistryObject<MenuType<ContainerDiskDrive>> DISK_DRIVE = CONTAINERS.register("disk_drive", () -> new MenuType(ContainerDiskDrive::new));
        public static final RegistryObject<MenuType<ContainerPrinter>> PRINTER = CONTAINERS.register("printer", () -> new MenuType(ContainerPrinter::new));
        public static final RegistryObject<MenuType<ContainerHeldItem>> PRINTOUT = CONTAINERS.register("printout", () -> ContainerData.toType(HeldItemContainerData::new, ContainerHeldItem::createPrintout));
        public static final RegistryObject<MenuType<ContainerViewComputer>> VIEW_COMPUTER = CONTAINERS.register("view_computer", () -> ContainerData.toType(ComputerContainerData::new, ContainerViewComputer::new));
    }
}

