/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.SidedCaps;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class TileWiredModemFull
extends TileGeneric {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private final SidedCaps<IPeripheral> modemCaps = SidedCaps.ofNonNull(this::getPeripheral);
    private boolean peripheralAccessAllowed = false;
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this.tickToken));
    private final WiredModemElement element = new FullElement(this);
    private LazyOptional<IWiredElement> elementCap;
    private final IWiredNode node = this.element.getNode();
    private final NonNullConsumer<LazyOptional<IWiredElement>> connectedNodeChanged = x -> this.connectionsChanged();
    private int invalidSides = 0;

    public TileWiredModemFull(BlockEntityType<TileWiredModemFull> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (int i = 0; i < this.peripherals.length; ++i) {
            Direction facing = Direction.m_122376_((int)i);
            this.peripherals[i] = new WiredModemLocalPeripheral(() -> this.queueRefreshPeripheral(facing));
        }
    }

    private void doRemove() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.doRemove();
        }
        super.destroy();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.doRemove();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        this.modemCaps.invalidate();
    }

    public void m_7651_() {
        super.m_7651_();
        this.doRemove();
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (!this.f_58857_.f_46443_ && this.peripheralAccessAllowed) {
            for (Direction facing : DirectionUtil.FACINGS) {
                if (!this.m_58899_().m_142300_(facing).equals((Object)neighbour)) continue;
                this.queueRefreshPeripheral(facing);
            }
        }
    }

    private void queueRefreshPeripheral(@Nonnull Direction facing) {
        if (this.invalidSides == 0) {
            TickScheduler.schedule(this.tickToken);
        }
        this.invalidSides |= 1 << facing.ordinal();
    }

    private void refreshPeripheral(@Nonnull Direction facing) {
        this.invalidSides &= ~(1 << facing.ordinal());
        WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
        if (this.f_58857_ != null && !this.m_58901_() && peripheral.attach(this.f_58857_, this.m_58899_(), facing)) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Set<String> oldPeriphNames = this.getConnectedPeripheralNames();
        this.togglePeripheralAccess();
        Set<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equal(periphNames, oldPeriphNames)) {
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return InteractionResult.SUCCESS;
    }

    private static void sendPeripheralChanges(Player player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        TextComponent base = new TextComponent("");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.m_130946_(", ");
            }
            base.m_7220_((Component)ChatHelpers.copy((String)names.get(i)));
        }
        player.m_5661_((Component)new TranslatableComponent(kind, new Object[]{base}), false);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheralAccessAllowed = nbt.m_128471_(NBT_PERIPHERAL_ENABLED);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        BlockState state = this.m_58900_();
        boolean modemOn = this.modemState.isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if ((Boolean)state.m_61143_((Property)BlockWiredModemFull.MODEM_ON) == modemOn && (Boolean)state.m_61143_((Property)BlockWiredModemFull.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)BlockWiredModemFull.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).m_61124_((Property)BlockWiredModemFull.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this.tickToken);
    }

    @Override
    public void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(direction);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                for (Direction facing : DirectionUtil.FACINGS) {
                    this.peripherals[facing.ordinal()].attach(this.f_58857_, this.m_58899_(), facing);
                }
                this.updateConnectedPeripherals();
            }
        }
    }

    private void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            LazyOptional<IWiredElement> element;
            BlockPos offset = current.m_142300_(facing);
            if (!world.m_46749_(offset) || !(element = ComputerCraftAPI.getWiredElementAt((BlockGetter)world, offset, facing.m_122424_())).isPresent()) continue;
            element.addListener(this.connectedNodeChanged);
            this.node.connectTo(((IWiredElement)element.orElseThrow(NullPointerException::new)).getNode());
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            boolean hasAny = false;
            for (Direction facing : DirectionUtil.FACINGS) {
                WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
                peripheral.attach(this.f_58857_, this.m_58899_(), facing);
                hasAny |= peripheral.hasPeripheral();
            }
            if (!hasAny) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.getConnectedPeripherals());
        } else {
            this.peripheralAccessAllowed = false;
            for (WiredModemLocalPeripheral peripheral : this.peripherals) {
                peripheral.detach();
            }
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private Set<String> getConnectedPeripheralNames() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptySet();
        }
        HashSet<String> peripherals = new HashSet<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        return peripherals;
    }

    private Map<String, IPeripheral> getConnectedPeripherals() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptyMap();
        }
        HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            peripheral.extendMap(peripherals);
        }
        return peripherals;
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.getConnectedPeripherals();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.CAPABILITY_WIRED_ELEMENT) {
            if (this.elementCap == null) {
                this.elementCap = LazyOptional.of(() -> this.element);
            }
            return this.elementCap.cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.modemCaps.get(side).cast();
        }
        return super.getCapability(capability, side);
    }

    public IWiredElement getElement() {
        return this.element;
    }

    private WiredModemPeripheral getPeripheral(final @Nonnull Direction side) {
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        final WiredModemLocalPeripheral localPeripheral = this.peripherals[side.ordinal()];
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element){

            @Override
            @Nonnull
            protected WiredModemLocalPeripheral getLocalPeripheral() {
                return localPeripheral;
            }

            @Override
            @Nonnull
            public Vec3 getPosition() {
                return Vec3.m_82512_((Vec3i)TileWiredModemFull.this.m_58899_().m_142300_(side));
            }

            @Override
            @Nonnull
            public Object getTarget() {
                return TileWiredModemFull.this;
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final TileWiredModemFull entity;

        private FullElement(TileWiredModemFull entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        @Nonnull
        public Level getLevel() {
            return this.entity.m_58904_();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)this.entity.m_58899_());
        }
    }
}

