/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundRemoveSubClaimPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundRemoveSubClaimPacket>, ClientboundRemoveSubClaimPacket> {
    public static final LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> ENCODER = new LazyPacket.Encoder();
    private final UUID playerId;
    private final int subConfigIndex;

    public ClientboundRemoveSubClaimPacket(UUID playerId, int subConfigIndex) {
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> encoder, FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("p", this.playerId);
        nbt.m_128405_("s", this.subConfigIndex);
        u.m_130079_(nbt);
    }

    public String toString() {
        return String.format("[%s, %d]", this.playerId, this.subConfigIndex);
    }

    public static class ClientHandler
    implements Consumer<ClientboundRemoveSubClaimPacket> {
        @Override
        public void accept(ClientboundRemoveSubClaimPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onRemoveSubClaim(t.playerId, t.subConfigIndex);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundRemoveSubClaimPacket> {
        @Override
        public ClientboundRemoveSubClaimPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                UUID playerId = nbt.m_128342_("p");
                int subConfigIndex = nbt.m_128451_("s");
                return new ClientboundRemoveSubClaimPacket(playerId, subConfigIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

