/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundSubClaimPropertiesPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket>, ClientboundSubClaimPropertiesPacket> {
    public static final int MAX_PROPERTIES = 32;
    public static final LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> ENCODER = new LazyPacket.Encoder();
    private final List<SubClaimProperties> properties;

    public ClientboundSubClaimPropertiesPacket(List<SubClaimProperties> properties) {
        this.properties = properties;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> encoder, FriendlyByteBuf dest) {
        CompoundTag nbt = new CompoundTag();
        ListTag propertiesListTag = new ListTag();
        for (int i = 0; i < this.properties.size(); ++i) {
            SubClaimProperties propertiesEntry = this.properties.get(i);
            CompoundTag propertiesEntryNbt = new CompoundTag();
            propertiesEntryNbt.m_128362_("p", propertiesEntry.playerId);
            propertiesEntryNbt.m_128405_("i", propertiesEntry.subConfigIndex);
            if (propertiesEntry.claimsName != null) {
                propertiesEntryNbt.m_128359_("n", propertiesEntry.claimsName);
            }
            if (propertiesEntry.claimsColor != null) {
                propertiesEntryNbt.m_128405_("c", propertiesEntry.claimsColor.intValue());
            }
            propertiesListTag.add((Object)propertiesEntryNbt);
        }
        nbt.m_128365_("l", (Tag)propertiesListTag);
        dest.m_130079_(nbt);
    }

    public static class SubClaimProperties {
        private final UUID playerId;
        private final int subConfigIndex;
        private final String claimsName;
        private final Integer claimsColor;

        public SubClaimProperties(UUID playerId, int subConfigIndex, String claimsName, Integer claimsColor) {
            this.playerId = playerId;
            this.subConfigIndex = subConfigIndex;
            this.claimsName = claimsName;
            this.claimsColor = claimsColor;
        }

        public String toString() {
            return String.format("[%s, %d, %s, %d]", this.playerId, this.subConfigIndex, this.claimsName, this.claimsColor);
        }
    }

    public static class ClientHandler
    implements Consumer<ClientboundSubClaimPropertiesPacket> {
        @Override
        public void accept(ClientboundSubClaimPropertiesPacket t) {
            for (SubClaimProperties propertiesEntry : t.properties) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onSubClaimInfo(propertiesEntry.playerId, propertiesEntry.subConfigIndex, propertiesEntry.claimsName, propertiesEntry.claimsColor);
            }
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundSubClaimPropertiesPacket> {
        @Override
        public ClientboundSubClaimPropertiesPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 32768) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                ListTag propertiesListTag = nbt.m_128437_("l", 10);
                if (propertiesListTag.size() > 32) {
                    OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list is too large!");
                    return null;
                }
                ArrayList<SubClaimProperties> propertiesList = new ArrayList<SubClaimProperties>(propertiesListTag.size());
                for (int i = 0; i < propertiesListTag.size(); ++i) {
                    CompoundTag propertiesEntryNbt = propertiesListTag.m_128728_(i);
                    String claimsName = propertiesEntryNbt.m_128461_("n");
                    if (claimsName.length() > 128) {
                        OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list with invalid claims name!");
                        return null;
                    }
                    UUID playerId = propertiesEntryNbt.m_128342_("p");
                    int subConfigIndex = propertiesEntryNbt.m_128451_("i");
                    Integer claimsColor = propertiesEntryNbt.m_128425_("c", 3) ? Integer.valueOf(propertiesEntryNbt.m_128451_("c")) : null;
                    propertiesList.add(new SubClaimProperties(playerId, subConfigIndex, claimsName, claimsColor));
                }
                return new ClientboundSubClaimPropertiesPacket(propertiesList);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

