/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.lazypacket.LazyPacketSender;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.task.ServerSpreadoutTaskHandler;

public final class ServerTickHandler {
    private final LazyPacketSender lazyPacketSender;
    private final List<ServerSpreadoutTaskHandler<?, ?>> spreadoutTaskHandlers;
    private long lastUseTimeUpdate;
    private long tickCounter;

    private ServerTickHandler(LazyPacketSender lazyPacketSender, List<ServerSpreadoutTaskHandler<?, ?>> spreadoutTaskHandlers) {
        this.lazyPacketSender = lazyPacketSender;
        this.spreadoutTaskHandlers = spreadoutTaskHandlers;
        this.lastUseTimeUpdate = System.currentTimeMillis();
    }

    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) throws Throwable {
        serverData.getIoThreadWorker().checkCrashes();
        ((ChunkProtection)serverData.getChunkProtection()).onServerTick();
        serverData.getPartyManagerIO().onServerTick();
        serverData.getPlayerConfigsIO().onServerTick();
        boolean hasSaved = serverData.getPartyLiveSaver().onServerTick() || serverData.getPlayerConfigLiveSaver().onServerTick() || serverData.getPlayerClaimInfoLiveSaver().onServerTick();
        this.lazyPacketSender.onServerTick();
        serverData.getPartyManager().getPartySynchronizer().onServerTick();
        serverData.getServerClaimsManager().getClaimsManagerSynchronizer().onServerTick();
        long time = System.currentTimeMillis();
        if (time - this.lastUseTimeUpdate > 600000L) {
            serverData.getServerInfo().setUseTime(serverData.getServerInfo().getUseTime() + (time - this.lastUseTimeUpdate));
            this.lastUseTimeUpdate = time;
            serverData.getServerInfoIO().save();
        }
        boolean expirationCheck = serverData.getPartyExpirationHandler().onServerTick(serverData) || serverData.getServerPlayerClaimsExpirationHandler().onServerTick(serverData);
        this.spreadoutTaskHandlers.forEach(th -> th.onTick(serverData));
        ++this.tickCounter;
    }

    public void registerSpreadoutTaskHandler(ServerSpreadoutTaskHandler<?, ?> handler) {
        if (!this.spreadoutTaskHandlers.contains(handler)) {
            this.spreadoutTaskHandlers.add(handler);
        }
    }

    public LazyPacketSender getLazyPacketSender() {
        return this.lazyPacketSender;
    }

    public long getTickCounter() {
        return this.tickCounter;
    }

    public static final class Builder {
        private MinecraftServer server;

        private Builder() {
        }

        public Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public ServerTickHandler build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            LazyPacketSender lazyPacketSender = LazyPacketSender.Builder.begin().setServer(this.server).setBytesPerTickLimit(104858).setCapacity(0x6400000).setBytesPerConfirmation(524280).build();
            return new ServerTickHandler(lazyPacketSender, new ArrayList());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

