/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyCommands;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class TransferPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> party.getOwner() == mi);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer").requires(requirement)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"new-owner", (ArgumentType)StringArgumentType.word()).suggests(PartyCommands.getPartyMemberSuggestor()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_transfer_use_confirm", new Object[0]));
            return 0;
        })).then(Commands.m_82127_((String)"confirm").executes(context -> {
            String targetUsername;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_142081_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            IPartyMember targetMember = (IPartyMember)playerParty.getMemberInfo(targetUsername = StringArgumentType.getString((CommandContext)context, (String)"new-owner"));
            if (targetMember == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_transfer_not_member", targetUsername));
                return 0;
            }
            if (targetMember == playerParty.getOwner()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_transfer_already_owner", targetUsername));
                return 0;
            }
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            if (playerParty.changeOwner(targetMember.getUUID(), targetMember.getUsername())) {
                UUID targetPlayerId = targetMember.getUUID();
                ServerPlayer newOwnerPlayer = server.m_6846_().m_11259_(targetPlayerId);
                if (newOwnerPlayer != null) {
                    server.m_129892_().m_82095_(newOwnerPlayer);
                }
                server.m_129892_().m_82095_(player);
                new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)new TranslatableComponent("gui.xaero_parties_transfer_success", new Object[]{new TextComponent(casterInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)), new TextComponent(targetMember.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.YELLOW))}));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_transfer_failed", new Object[0]));
            return 0;
        }))));
        dispatcher.register(command);
    }
}

