/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.registry;

import com.github.talrey.createdeco.Registration;
import com.github.talrey.createdeco.blocks.CageLampBlock;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.DyedPlacardBlock;
import com.github.talrey.createdeco.blocks.DyedPlacardBlockEntity;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.github.talrey.createdeco.registry.DecoCreativeModeTab;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.decoration.placard.PlacardRenderer;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class Props {
    public static HashMap<DyeColor, BlockEntry<DecalBlock>> DECAL_BLOCKS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> YELLOW_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> RED_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> GREEN_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> BLUE_CAGE_LAMPS = new HashMap();
    public static HashMap<String, ItemEntry<Item>> COIN_ITEM = new HashMap();
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACK_ITEM = new HashMap();
    public static HashMap<String, BlockEntry<CoinStackBlock>> COIN_BLOCKS = new HashMap();
    public static TagKey<Item> PLACARD_TAG;
    public static HashMap<DyeColor, BlockEntry<? extends PlacardBlock>> PLACARDS;
    public static BlockEntityEntry<DyedPlacardBlockEntity> PLACARD_ENTITY;
    public static ArrayList<String> COIN_TYPES;
    public static final ResourceLocation YELLOW_ON;
    public static final ResourceLocation YELLOW_OFF;
    public static final ResourceLocation RED_ON;
    public static final ResourceLocation RED_OFF;
    public static final ResourceLocation GREEN_ON;
    public static final ResourceLocation GREEN_OFF;
    public static final ResourceLocation BLUE_ON;
    public static final ResourceLocation BLUE_OFF;

    private static String prettyName(String original) {
        StringBuilder builder = new StringBuilder();
        for (String part : original.split("_")) {
            builder.append(part.charAt(0));
            builder.append(part.substring(1).toLowerCase(Locale.ROOT));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static ItemBuilder<CoinStackItem, ?> buildCoinStackItem(Registrate reg, NonNullSupplier<Item> coin, String name) {
        return reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack", p -> new CoinStackItem((Item.Properties)p, name)).properties(p -> name.contains("Netherite") ? p.m_41486_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)coin.get(), 4).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)coin.get()})).m_176498_((Consumer)prov)).lang(name + " Coinstack");
    }

    public static ItemBuilder<Item, ?> buildCoinItem(Registrate reg, NonNullSupplier<Item> coinstack, String name) {
        return reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coin", Item::new).properties(p -> name.contains("Netherite") ? p.m_41486_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ctx.get()), (int)4).m_126209_((ItemLike)coinstack.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)coinstack.get()})).m_176498_((Consumer)prov)).lang(name + " Coin");
    }

    public static BlockBuilder<CoinStackBlock, ?> buildCoinStackBlock(Registrate reg, NonNullSupplier<Item> material, String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_block", p -> new CoinStackBlock((BlockBehaviour.Properties)p, name)).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56728_)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int layer = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + layer, prov.modLoc("block/layers_bottom_top_" + layer))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).build();
        })).addLayer(() -> RenderType::m_110457_).lang(name + " Stack Block").loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            for (int layer = 1; layer <= 8; ++layer) {
                LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)((ItemLike)material.get()));
                ((LootPoolSingletonContainer.Builder)entry.m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61417_, layer)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)layer)));
                pool.m_79076_((LootPoolEntryContainer.Builder)entry);
            }
            table.m_124165_((Block)block, builder.m_79161_(pool));
        });
    }

    public static BlockBuilder<CageLampBlock, ?> buildCageLamp(Registrate reg, String name, DyeColor color, ResourceLocation cage, ResourceLocation lampOn, ResourceLocation lampOff) {
        return reg.block(color.m_41065_().toLowerCase(Locale.ROOT) + "_" + name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp", p -> new CageLampBlock((BlockBehaviour.Properties)p, new Vector3f(0.3f, 0.3f, 0.0f))).initialProperties(Material.f_76279_).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56762_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int y = 0;
            int x = 90;
            switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                case NORTH: {
                    y = 0;
                    break;
                }
                case SOUTH: {
                    y = 180;
                    break;
                }
                case WEST: {
                    y = -90;
                    break;
                }
                case EAST: {
                    y = 90;
                    break;
                }
                case DOWN: {
                    x = 180;
                    break;
                }
                default: {
                    x = 0;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "" : "_off"), prov.modLoc("block/cage_lamp"))).texture("cage", cage)).texture("lamp", (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lampOn : lampOff)).texture("particle", cage)).rotationX(x).rotationY(y).build();
        })).addLayer(() -> RenderType::m_110457_).lang(color.name().charAt(0) + color.name().substring(1).toLowerCase() + " " + name + " Cage Lamp").simpleItem();
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.PROPS_GROUP);
        COIN_TYPES.forEach(metal -> {
            ResourceLocation side = new ResourceLocation("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_side");
            ResourceLocation top = new ResourceLocation("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_top");
            ResourceLocation bottom = new ResourceLocation("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_bottom");
            COIN_BLOCKS.put((String)metal, (BlockEntry<CoinStackBlock>)Props.buildCoinStackBlock(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)COINSTACK_ITEM.get(metal).get()), metal, side, bottom, top).register());
        });
        for (DyeColor color : DyeColor.values()) {
            DECAL_BLOCKS.put(color, (BlockEntry<DecalBlock>)((BlockBuilder)reg.block(color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_decal", DecalBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56762_)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int y = 0;
                switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/decal"))).texture("face", prov.modLoc("block/palettes/decal/" + ctx.getName()))).texture("particle", prov.modLoc("block/palettes/decal/" + ctx.getName()))).rotationY(y).build();
            })).addLayer(() -> RenderType::m_110457_).lang(Props.prettyName(color.name()) + "Decal").item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/decal/" + ctx.getName()))).build()).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)AllItems.IRON_SHEET.get(), 1).m_126211_((ItemLike)DyeItem.m_41082_((DyeColor)color), 1).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.IRON_SHEET.get()})).m_142284_("has_dye", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)color)})).m_176498_((Consumer)prov)).register());
        }
        Registration.METAL_TYPES.forEach((metal, getter) -> {
            ResourceLocation cage = new ResourceLocation("createdeco", "block/palettes/cage_lamp/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp");
            TagKey<Item> nugget = Registration.makeItemTag("nuggets/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
            TagKey<Item> plate = Registration.makeItemTag("plates/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
            YELLOW_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, DyeColor.YELLOW, cage, YELLOW_ON, YELLOW_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_206416_(Character.valueOf('n'), nugget).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42000_).m_206416_(Character.valueOf('p'), plate).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(plate).m_45077_()})).m_176498_((Consumer)prov);
                } else {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_126127_(Character.valueOf('n'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42000_).m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()}).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).register());
            RED_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, DyeColor.RED, cage, RED_ON, RED_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_206416_(Character.valueOf('n'), nugget).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_41978_).m_206416_(Character.valueOf('p'), plate).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(plate).m_45077_()})).m_176498_((Consumer)prov);
                } else {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_126127_(Character.valueOf('n'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()}).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).register());
            GREEN_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, DyeColor.GREEN, cage, GREEN_ON, GREEN_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_206416_(Character.valueOf('n'), nugget).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_151079_).m_206416_(Character.valueOf('p'), plate).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(plate).m_45077_()})).m_176498_((Consumer)prov);
                } else {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_126127_(Character.valueOf('n'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_151079_).m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()}).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).register());
            BLUE_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, DyeColor.BLUE, cage, BLUE_ON, BLUE_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_206416_(Character.valueOf('n'), nugget).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42053_).m_206416_(Character.valueOf('p'), plate).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(plate).m_45077_()})).m_176498_((Consumer)prov);
                } else {
                    ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("n").m_126130_("t").m_126130_("p").m_126127_(Character.valueOf('n'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42053_).m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()}).m_45077_()})).m_176498_((Consumer)prov);
                }
            }).register());
        });
        if (PLACARD_TAG == null) {
            PLACARD_TAG = Registration.makeItemTag("createdeco", "placards");
        }
        for (DyeColor color : DyeColor.values()) {
            if (color == DyeColor.WHITE) continue;
            String regName = color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_placard";
            PLACARDS.put(color, (BlockEntry<? extends PlacardBlock>)((BlockBuilder)((BlockBuilder)reg.block(regName, DyedPlacardBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).blockstate((ctx, prov) -> prov.horizontalFaceBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(regName, prov.modLoc("block/dyed_placard"))).texture("0", prov.modLoc("block/palettes/placard/" + regName))).texture("particle", prov.modLoc("block/palettes/placard/" + regName)))).simpleItem().recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_206419_(PLACARD_TAG).m_126209_((ItemLike)DyeItem.m_41082_((DyeColor)color)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(PLACARD_TAG).m_45077_()})).m_142284_("has_dye", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{DyeItem.m_41082_((DyeColor)color)}).m_45077_()})).m_142409_("dye_placard").m_176498_((Consumer)prov)).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.referKey((ItemLike)v, (Supplier)AllBlocks.PLACARD))).register());
            TooltipModifier.REGISTRY.registerDeferred(PLACARDS.get(color).getId(), item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.EMPTY)));
        }
        BlockEntry[] validPlacards = new BlockEntry[PLACARDS.size()];
        int color = 0;
        Iterator<BlockEntry<? extends PlacardBlock>> iterator = PLACARDS.values().iterator();
        while (iterator.hasNext()) {
            BlockEntry<? extends PlacardBlock> block;
            validPlacards[color] = block = iterator.next();
        }
        PLACARD_ENTITY = reg.blockEntity("dyed_placard", DyedPlacardBlockEntity::new).renderer(() -> PlacardRenderer::new).validBlocks((NonNullSupplier[])PLACARDS.values().toArray(validPlacards)).register();
    }

    public static void registerItems(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.PROPS_GROUP, "CreateDeco Props");
        for (String metal : COIN_TYPES) {
            COIN_ITEM.put(metal, (ItemEntry<Item>)Props.buildCoinItem(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)COINSTACK_ITEM.get(metal).get()), metal).register());
            COINSTACK_ITEM.put(metal, (ItemEntry<CoinStackItem>)Props.buildCoinStackItem(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)COIN_ITEM.get(metal).get()), metal).register());
        }
    }

    static {
        PLACARDS = new HashMap();
        COIN_TYPES = new ArrayList();
        YELLOW_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_default");
        YELLOW_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_default_off");
        RED_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_redstone");
        RED_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_redstone_off");
        GREEN_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_green");
        GREEN_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_green_off");
        BLUE_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_soul");
        BLUE_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_soul_off");
    }
}

