/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.mixin.common.access.brewing.AccessPotionBrewing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByReagent
extends ActionBrewingBase {
    private final IItemStack reagent;
    private final List<PotionBrewing.Mix<Potion>> removed = new ArrayList<PotionBrewing.Mix<Potion>>();
    private final List<IBrewingRecipe> removedRecipes = new ArrayList<IBrewingRecipe>();

    public ActionRemoveBrewingRecipeByReagent(List<IBrewingRecipe> recipes, IItemStack reagent) {
        super(recipes);
        this.reagent = reagent;
    }

    @Override
    public void apply() {
        Iterator<PotionBrewing.Mix<Potion>> vanillaIterator = AccessPotionBrewing.crafttweaker$getPOTION_MIXES().iterator();
        while (vanillaIterator.hasNext()) {
            PotionBrewing.Mix<Potion> mix = vanillaIterator.next();
            Ingredient reagentInput = mix.f_43533_;
            if (reagentInput == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!reagentInput.test(this.reagent.getInternal())) continue;
            this.removed.add(mix);
            vanillaIterator.remove();
        }
        Iterator registryIterator = this.recipes.iterator();
        while (registryIterator.hasNext()) {
            IBrewingRecipe next = (IBrewingRecipe)registryIterator.next();
            if (!next.isIngredient(this.reagent.getInternal())) continue;
            this.removedRecipes.add(next);
            registryIterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.Mix<Potion> potion : this.removed) {
            IRegistryDelegate potionInput = potion.f_43532_;
            Ingredient itemReagent = potion.f_43533_;
            IRegistryDelegate potionOutput = potion.f_43534_;
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.LOGGER.error("Error getting mix entries! potionInput: {}, itemReagent: {}, potionOutput: {}", (Object)potionInput, (Object)itemReagent, (Object)potionOutput);
                continue;
            }
            AccessPotionBrewing.crafttweaker$callAddMix((Potion)potionInput.get(), itemReagent.m_43908_()[0].m_41720_(), (Potion)potionOutput.get());
        }
        this.removedRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have a reagent of: " + this.reagent;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have a reagent of: " + this.reagent;
    }
}

