/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.ancient;

import com.infamous.dungeons_mobs.capabilities.ancient.Ancient;
import com.infamous.dungeons_mobs.capabilities.ancient.AncientHelper;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import com.infamous.dungeons_mobs.network.message.AncientMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class AncientEvents {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Ancient cap;
        Player player = event.getPlayer();
        Entity target = event.getTarget();
        if (player instanceof ServerPlayer && (cap = AncientHelper.getAncientCapability(target)).isAncient()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new AncientMessage(target.m_142049_(), cap.isAncient()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Ancient cap;
        LivingEntity entityLiving = event.getEntityLiving();
        if (!entityLiving.f_19853_.f_46443_ && (cap = AncientHelper.getAncientCapability((Entity)entityLiving)).isAncient() && cap.getBossInfo() != null) {
            List nearbyEntities = entityLiving.f_19853_.m_45971_(ServerPlayer.class, TargetingConditions.m_148353_().m_26883_(20.0).m_26893_(), entityLiving, entityLiving.m_142469_().m_82377_(20.0, 10.0, 20.0));
            nearbyEntities.forEach(playerEntity -> cap.getBossInfo().m_6543_(playerEntity));
            ArrayList<ServerPlayer> trackingPlayers = new ArrayList<ServerPlayer>(cap.getBossInfo().m_8324_());
            List furtherEntities = entityLiving.f_19853_.m_45971_(ServerPlayer.class, TargetingConditions.m_148353_().m_26883_(50.0).m_26893_(), entityLiving, entityLiving.m_142469_().m_82377_(50.0, 20.0, 50.0));
            trackingPlayers.forEach(playerEntity -> {
                if (!furtherEntities.contains(playerEntity)) {
                    cap.getBossInfo().m_6539_(playerEntity);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        Ancient cap = AncientHelper.getAncientCapability((Entity)livingEntity);
        if (cap.isAncient() && cap.getBossInfo() != null) {
            cap.getBossInfo().m_142711_(livingEntity.m_21223_() / livingEntity.m_21233_());
        }
    }
}

