/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.ancient;

import com.infamous.dungeons_mobs.capabilities.ModCapabilities;
import com.infamous.dungeons_mobs.capabilities.ancient.Ancient;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class AttacherAncient {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            AncientProvider provider = new AncientProvider();
            event.addCapability(AncientProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class AncientProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("dungeons_mobs", "ancient");
        private final Ancient backend = new Ancient();
        private final LazyOptional<Ancient> optionalData = LazyOptional.of(() -> this.backend);

        private AncientProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.ANCIENT_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

