/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.animatedprops;

import com.infamous.dungeons_mobs.capabilities.ModCapabilities;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class AttacherAnimatedProps {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Vindicator) {
            AnimatedPropsProvider provider = new AnimatedPropsProvider();
            event.addCapability(AnimatedPropsProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class AnimatedPropsProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("dungeons_mobs", "convertible");
        private final AnimatedProps backend = new AnimatedProps();
        private final LazyOptional<AnimatedProps> optionalData = LazyOptional.of(() -> this.backend);

        private AnimatedPropsProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.ANIMATED_PROPS_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

