/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.convertible;

import com.infamous.dungeons_mobs.capabilities.ModCapabilities;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.util.INBTSerializable;

public class Convertible
implements INBTSerializable<CompoundTag> {
    boolean isConverting;
    private boolean canConvert;
    int conversionTime;
    int prepareConversionTime;

    public void tickConversionTime() {
        this.setConversionTime(this.getConversionTime() - 1);
    }

    public <T extends Mob> T doConversion(Mob original, EntityType<T> convertToType, BiConsumer<Mob, T> onConversion) {
        Mob convertedTo = original.m_21406_(convertToType, true);
        onConversion.accept(original, convertedTo);
        return (T)convertedTo;
    }

    public void startConversion(int conversionLength) {
        this.setConverting(true);
        this.setConversionTime(conversionLength);
    }

    public void tickPrepareConversionTime() {
        this.setPrepareConversionTime(this.getPrepareConversionTime() + 1);
    }

    public boolean isConverting() {
        return this.isConverting;
    }

    public void setConverting(boolean converting) {
        this.isConverting = converting;
    }

    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    public int getConversionTime() {
        return this.conversionTime;
    }

    public void setPrepareConversionTime(int prepareConversionTime) {
        this.prepareConversionTime = prepareConversionTime;
    }

    public int getPrepareConversionTime() {
        return this.prepareConversionTime;
    }

    public boolean canConvert() {
        return this.canConvert;
    }

    public void setCanConvert(boolean canConvert) {
        this.canConvert = canConvert;
    }

    public CompoundTag serializeNBT() {
        if (ModCapabilities.CONVERTIBLE_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("conversionTime", this.isConverting() ? this.getConversionTime() : -1);
        tag.m_128405_("prepareConversionTime", this.canConvert() ? this.getPrepareConversionTime() : -1);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setPrepareConversionTime(tag.m_128451_("prepareConversionTime"));
        if (tag.m_128425_("DrownedConversionTime", 99) && tag.m_128451_("conversionTime") > -1) {
            this.startConversion(tag.m_128451_("conversionTime"));
        }
    }
}

