/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.properties;

import com.infamous.dungeons_mobs.capabilities.ModCapabilities;
import com.infamous.dungeons_mobs.capabilities.properties.MobProps;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class AttacherMobProps {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            MobPropsProvider provider = new MobPropsProvider();
            event.addCapability(MobPropsProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class MobPropsProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("dungeons_mobs", "mob_props");
        private final MobProps backend = new MobProps();
        private final LazyOptional<MobProps> optionalData = LazyOptional.of(() -> this.backend);

        private MobPropsProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.MOB_PROPS_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

