/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.illager;

import com.infamous.dungeons_mobs.entities.illagers.GeomancerEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class GeomancerModel
extends AnimatedGeoModel<GeomancerEntity> {
    public ResourceLocation getAnimationFileLocation(GeomancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "animations/geomancer.animation.json");
    }

    public ResourceLocation getModelLocation(GeomancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "geo/geomancer.geo.json");
    }

    public ResourceLocation getTextureLocation(GeomancerEntity entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/illager/geomancer.png");
    }

    public void setCustomAnimations(GeomancerEntity entity, int uniqueID, AnimationEvent customPredicate) {
        super.setCustomAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("bipedHead");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        IBone illagerArms = this.getAnimationProcessor().getBone("illagerArms");
        cape.setHidden(true);
        illagerArms.setHidden(true);
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", () -> groundSpeed * 20.0f);
    }
}

