/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.jungle;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.jungle.WhispererEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class WhispererModel<T extends WhispererEntity>
extends AnimatedGeoModel<T> {
    public ResourceLocation getAnimationFileLocation(T entity) {
        return new ResourceLocation("dungeons_mobs", "animations/whisperer.animation.json");
    }

    public ResourceLocation getModelLocation(T entity) {
        return new ResourceLocation("dungeons_mobs", "geo/whisperer.geo.json");
    }

    public ResourceLocation getTextureLocation(T entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/jungle/whisperer.png");
    }

    public void setCustomAnimations(T entity, int uniqueID, AnimationEvent customPredicate) {
        GeoBone rightHandBone;
        GeoBone leftHandBone;
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("jaw");
        IBone cape = this.getAnimationProcessor().getBone("bipedCape");
        cape.setHidden(true);
        IBone leftHand = this.getAnimationProcessor().getBone("bipedHandLeft");
        IBone rightHand = this.getAnimationProcessor().getBone("bipedHandRight");
        if (((WhispererEntity)entity).f_19797_ % 1 == 0 && rightHand instanceof GeoBone && leftHand instanceof GeoBone && ((WhispererEntity)entity).isSpellcasting()) {
            leftHandBone = (GeoBone)leftHand;
            rightHandBone = (GeoBone)rightHand;
            ((WhispererEntity)entity).f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CORRUPTED_MAGIC.get(), leftHandBone.getWorldPosition().f_86214_, leftHandBone.getWorldPosition().f_86215_, leftHandBone.getWorldPosition().f_86216_, 0.0, 0.0, 0.0);
            ((WhispererEntity)entity).f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CORRUPTED_MAGIC.get(), rightHandBone.getWorldPosition().f_86214_, rightHandBone.getWorldPosition().f_86215_, rightHandBone.getWorldPosition().f_86216_, 0.0, 0.0, 0.0);
        }
        if (((WhispererEntity)entity).f_19797_ % 2 == 0 && rightHand instanceof GeoBone && leftHand instanceof GeoBone && ((WhispererEntity)entity).isSpellcasting()) {
            leftHandBone = (GeoBone)leftHand;
            rightHandBone = (GeoBone)rightHand;
            ((WhispererEntity)entity).f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CORRUPTED_DUST.get(), leftHandBone.getWorldPosition().f_86214_, leftHandBone.getWorldPosition().f_86215_, leftHandBone.getWorldPosition().f_86216_, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01);
            ((WhispererEntity)entity).f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CORRUPTED_DUST.get(), rightHandBone.getWorldPosition().f_86214_, rightHandBone.getWorldPosition().f_86215_, rightHandBone.getWorldPosition().f_86216_, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01, entity.m_21187_().nextGaussian() * 0.01);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", () -> (double)groundSpeed * 12.5);
    }
}

