/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class DefaultIllagerRenderer<T extends Mob>
extends ExtendedGeoEntityRenderer<T> {
    private float scaleFactor = 0.9375f;

    public DefaultIllagerRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager, modelProvider);
    }

    public DefaultIllagerRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider, float scaleFactor) {
        super(renderManager, modelProvider);
        this.scaleFactor = scaleFactor;
    }

    protected void applyRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStackIn.m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
        super.applyRotations(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public RenderType getRenderType(T animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String s, T currentEntity) {
        return null;
    }

    protected ItemStack getHeldItemForBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.m_21526_() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.m_21526_() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemTransforms.TransformType.NONE;
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, T currentEntity, IBone bone) {
        if (item == this.mainHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, -0.25);
            }
        } else if (item == this.offHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, T currentEntity, IBone bone) {
    }

    protected BlockState getHeldBlockForBone(String boneName, T currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack matrixStack, BlockState block, String boneName, T currentEntity) {
    }

    protected void postRenderBlock(PoseStack matrixStack, BlockState block, String boneName, T currentEntity) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return currentEntity.m_6844_(EquipmentSlot.FEET);
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return currentEntity.m_6844_(EquipmentSlot.LEGS);
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return currentEntity.m_6844_(EquipmentSlot.CHEST);
            }
            case "armorBipedHead": {
                return currentEntity.m_6844_(EquipmentSlot.HEAD);
            }
        }
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlot.LEGS;
            }
            case "armorBipedRightHand": {
                return !currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedLeftHand": {
                return currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": 
            case "armorBipedBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorBipedModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorBipedModel.f_102814_;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorBipedModel.f_102813_;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorBipedModel.f_102811_;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorBipedModel.f_102812_;
            }
            case "armorBipedBody": {
                return armorBipedModel.f_102810_;
            }
            case "armorBipedHead": {
                return armorBipedModel.f_102808_;
            }
        }
        return null;
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack, boolean geoArmor, boolean modMatrixRot) {
        super.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, geoArmor, modMatrixRot);
        if (bone.getName().equals("armorBipedHead") && geoArmor && this.helmet.m_41720_().getRegistryName().m_135827_().equals("dungeons_mobs")) {
            stack.m_85837_(0.0, 0.125, 0.0);
        }
    }

    protected void setLimbBoneVisible(GeoArmorRenderer<? extends GeoArmorItem> armorRenderer, ModelPart limb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        if (limb == armorModel.f_102808_ || limb == armorModel.f_102809_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.headBone).setHidden(false);
        } else if (limb == armorModel.f_102810_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102812_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102814_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftLegBone : armorRenderer.leftBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightLegBone).setHidden(true);
        } else if (limb == armorModel.f_102811_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(false);
        } else if (limb == armorModel.f_102813_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightLegBone : armorRenderer.rightBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftLegBone).setHidden(true);
        }
    }
}

