/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.redstone;

import com.infamous.dungeons_mobs.client.models.geom.ModModelLayers;
import com.infamous.dungeons_mobs.client.models.redstone.RedstoneCubeModel;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneCubeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedstoneCubeRenderer
extends MobRenderer<RedstoneCubeEntity, RedstoneCubeModel<RedstoneCubeEntity>> {
    private static final ResourceLocation REDSTONE_CUBE_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/redstone/redstone_cube.png");

    public RedstoneCubeRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext, new RedstoneCubeModel(renderContext.m_174023_(ModModelLayers.REDSTONE_CUBE)), 0.25f);
    }

    public void render(RedstoneCubeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.f_114477_ = 0.5f;
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void setupRotations(RedstoneCubeEntity redstoneCubeEntity, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)redstoneCubeEntity, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (redstoneCubeEntity.isRolling()) {
            float rotationPerTick = 18.0f;
            float rotationAmount = ((float)redstoneCubeEntity.f_19797_ + partialTicks) * -rotationPerTick;
            this.rollCube(matrixStackIn, rotationAmount);
        }
    }

    private void rollCube(PoseStack matrixStackIn, float rotationAmount) {
        Vec3 offset = new Vec3(0.0, 0.5, 0.0);
        matrixStackIn.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(rotationAmount));
        matrixStackIn.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
    }

    protected void scale(RedstoneCubeEntity redstoneCubeEntity, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
        float sizeScaleFactor = 2.0f;
        matrixStackIn.m_85841_(sizeScaleFactor, sizeScaleFactor, sizeScaleFactor);
    }

    public ResourceLocation getTextureLocation(RedstoneCubeEntity entity) {
        return REDSTONE_CUBE_TEXTURE;
    }
}

