/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.undead;

import com.infamous.dungeons_mobs.client.models.undead.WraithModel;
import com.infamous.dungeons_mobs.client.renderer.layers.PulsatingGlowLayer;
import com.infamous.dungeons_mobs.entities.undead.WraithEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class WraithRenderer
extends ExtendedGeoEntityRenderer<WraithEntity> {
    public WraithRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new WraithModel());
        this.addLayer(new PulsatingGlowLayer(this, new ResourceLocation("dungeons_mobs", "textures/entity/wraith/wraith_glow.png"), 0.1f, 1.0f, 0.25f));
    }

    protected void applyRotations(WraithEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float scaleFactor = 1.0f;
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public RenderType getRenderType(WraithEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String s, WraithEntity windcallerEntity) {
        return null;
    }

    protected ItemStack getHeldItemForBone(String boneName, WraithEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.m_21526_() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.m_21526_() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemTransforms.TransformType.NONE;
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, WraithEntity currentEntity, IBone bone) {
        if (item == this.mainHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, -0.25);
            }
        } else if (item == this.offHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, WraithEntity currentEntity, IBone bone) {
    }

    protected BlockState getHeldBlockForBone(String boneName, WraithEntity currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack matrixStack, BlockState block, String boneName, WraithEntity currentEntity) {
    }

    protected void postRenderBlock(PoseStack matrixStack, BlockState block, String boneName, WraithEntity currentEntity) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, WraithEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.boots;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggings;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return this.chestplate;
            }
            case "armorBipedHead": {
                return this.helmet;
            }
        }
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, WraithEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlot.LEGS;
            }
            case "armorBipedRightHand": {
                return !currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedLeftHand": {
                return currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": 
            case "armorBipedBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorBipedModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorBipedModel.f_102814_;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorBipedModel.f_102813_;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorBipedModel.f_102811_;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorBipedModel.f_102812_;
            }
            case "armorBipedBody": {
                return armorBipedModel.f_102810_;
            }
            case "armorBipedHead": {
                return armorBipedModel.f_102808_;
            }
        }
        return null;
    }
}

