/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.util;

import com.google.common.collect.Maps;
import com.infamous.dungeons_mobs.client.renderer.util.ModGeoReplacedEntityRenderer;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public abstract class ModExtentedGeoReplacedEntityRenderer<T extends IAnimatable>
extends ModGeoReplacedEntityRenderer<T> {
    protected float widthScale;
    protected float heightScale;
    protected final Queue<Tuple<GeoBone, ItemStack>> HEAD_QUEUE = new ArrayDeque<Tuple<GeoBone, ItemStack>>();
    private software.bernie.geckolib3.util.EModelRenderCycle currentModelRenderCycle = software.bernie.geckolib3.util.EModelRenderCycle.INITIAL;
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_INNER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_OUTER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
    private VertexConsumer currentVertexBuilderInUse;
    private float currentPartialTicks;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public ModExtentedGeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        this(renderManager, modelProvider, animatable, 1.0f, 1.0f, 0.0f);
    }

    protected ModExtentedGeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animation, float widthScale, float heightScale, float shadowSize) {
        super(renderManager, modelProvider, animation);
        this.f_114477_ = shadowSize;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
    }

    @Override
    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        this.setCurrentModelRenderCycle((software.bernie.geckolib3.util.IRenderCycle)software.bernie.geckolib3.util.EModelRenderCycle.INITIAL);
        super.render(entity, animatable, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    protected void renderHeads(PoseStack stack, MultiBufferSource buffer, int packedLightIn) {
        while (!this.HEAD_QUEUE.isEmpty()) {
            Tuple<GeoBone, ItemStack> entry = this.HEAD_QUEUE.poll();
            GeoBone bone = (GeoBone)entry.m_14418_();
            ItemStack itemStack = (ItemStack)entry.m_14419_();
            stack.m_85836_();
            this.moveAndRotateMatrixToMatchBone(stack, bone);
            GameProfile skullOwnerProfile = null;
            if (itemStack.m_41782_()) {
                String s;
                CompoundTag compoundnbt = itemStack.m_41783_();
                if (compoundnbt.m_128425_("SkullOwner", 10)) {
                    skullOwnerProfile = NbtUtils.m_129228_((CompoundTag)compoundnbt.m_128469_("SkullOwner"));
                } else if (compoundnbt.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)(s = compoundnbt.m_128461_("SkullOwner")))) {
                    SkullBlockEntity.m_155738_((GameProfile)new GameProfile((UUID)null, s), p_172560_ -> compoundnbt.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)p_172560_)));
                }
            }
            float sx = 1.0f;
            float sy = 1.0f;
            float sz = 1.0f;
            try {
                GeoCube firstCube = (GeoCube)bone.childCubes.get(0);
                if (firstCube != null) {
                    sx = firstCube.size.m_122239_() / 8.0f;
                    sy = firstCube.size.m_122260_() / 8.0f;
                    sz = firstCube.size.m_122269_() / 8.0f;
                }
            }
            catch (IndexOutOfBoundsException firstCube) {
                // empty catch block
            }
            stack.m_85841_(1.1875f * sx, 1.1875f * sy, 1.1875f * sz);
            stack.m_85837_(-0.5, 0.0, -0.5);
            SkullBlock.Type skullblock$type = ((AbstractSkullBlock)((BlockItem)itemStack.m_41720_()).m_40614_()).m_48754_();
            SkullModelBase skullmodelbase = (SkullModelBase)SkullBlockRenderer.m_173661_((EntityModelSet)Minecraft.m_91087_().m_167973_()).get(skullblock$type);
            RenderType rendertype = SkullBlockRenderer.m_112523_((SkullBlock.Type)skullblock$type, (GameProfile)skullOwnerProfile);
            SkullBlockRenderer.m_173663_((Direction)null, (float)0.0f, (float)0.0f, (PoseStack)stack, (MultiBufferSource)buffer, (int)packedLightIn, (SkullModelBase)skullmodelbase, (RenderType)rendertype);
            stack.m_85849_();
        }
    }

    public void render(GeoModel model, Object animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.setCurrentModelRenderCycle((software.bernie.geckolib3.util.IRenderCycle)software.bernie.geckolib3.util.EModelRenderCycle.REPEATED);
        this.renderHeads(matrixStackIn, renderTypeBuffer, packedLightIn);
    }

    protected float getWidthScale(T entity) {
        return this.widthScale;
    }

    protected float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(Object animatable, PoseStack stackIn, float partialTicks, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.rtb = renderTypeBuffer;
        super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.getCurrentModelRenderCycle() == software.bernie.geckolib3.util.EModelRenderCycle.INITIAL && animatable instanceof IAnimatable) {
            float width = this.getWidthScale((IAnimatable)animatable);
            float height = this.getHeightScale((IAnimatable)animatable);
            stackIn.m_85841_(width, height, width);
        }
    }

    public void renderLate(Object animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.renderLate(animatable, stackIn, partialTicks, renderTypeBuffer, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.currentVertexBuilderInUse = bufferIn;
        this.currentPartialTicks = partialTicks;
    }

    protected abstract boolean isArmorBone(GeoBone var1);

    protected void moveAndRotateMatrixToMatchBone(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(bone.getRotationX()));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(bone.getRotationY()));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(bone.getRotationZ()));
    }

    protected void handleArmorRenderingForBone(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, ResourceLocation currentTexture) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ItemStack armorForBone = this.getArmorForBone(bone.getName(), this.currentAnimatable);
        EquipmentSlot boneSlot = this.getEquipmentSlotForArmorBone(bone.getName(), this.currentAnimatable);
        if (armorForBone != null && boneSlot != null) {
            if (armorForBone.m_41720_() instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorForBone.m_41720_();
                HumanoidModel armorModel = (HumanoidModel)ForgeHooksClient.getArmorModel((LivingEntity)this.currentEntity, (ItemStack)armorForBone, (EquipmentSlot)boneSlot, boneSlot == EquipmentSlot.LEGS ? this.DEFAULT_BIPED_ARMOR_MODEL_INNER : this.DEFAULT_BIPED_ARMOR_MODEL_OUTER);
                ModelPart sourceLimb = this.getArmorPartForBone(bone.getName(), armorModel);
                if (armorModel != null) {
                    List cubeList;
                    if (armorForBone.m_41720_() instanceof GeoArmorItem) {
                        List cubeList2;
                        GeoArmorRenderer geoArmorRenderer = GeoArmorRenderer.getRenderer(armorItem.getClass(), (Entity)this.currentEntity);
                        if (sourceLimb != null && !(cubeList2 = sourceLimb.f_104212_).isEmpty()) {
                            stack.m_85841_(-1.0f, -1.0f, 1.0f);
                            stack.m_85836_();
                            this.prepareArmorPositionAndScale(bone, cubeList2, sourceLimb, stack, false, boneSlot == EquipmentSlot.CHEST);
                            geoArmorRenderer.setCurrentItem(this.currentEntity, armorForBone, boneSlot);
                            geoArmorRenderer.applySlot(boneSlot);
                            this.handleGeoArmorBoneVisibility((GeoArmorRenderer<GeoArmorItem>)geoArmorRenderer, sourceLimb, armorModel, boneSlot);
                            VertexConsumer ivb = ItemRenderer.m_115184_((MultiBufferSource)this.rtb, (RenderType)RenderType.m_110431_((ResourceLocation)GeoArmorRenderer.getRenderer(armorItem.getClass(), (Entity)this.currentEntity).getTextureLocation(armorItem)), (boolean)false, (boolean)armorForBone.m_41790_());
                            geoArmorRenderer.render(this.currentPartialTicks, stack, ivb, packedLightIn);
                            stack.m_85849_();
                        }
                    } else if (sourceLimb != null && !(cubeList = sourceLimb.f_104212_).isEmpty()) {
                        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack);
                        stack.m_85841_(-1.0f, -1.0f, 1.0f);
                        stack.m_85836_();
                        ResourceLocation armorResource = this.getArmorResource((Entity)this.currentEntity, armorForBone, boneSlot, null);
                        this.renderArmorOfItem(armorItem, armorForBone, boneSlot, armorResource, sourceLimb, stack, packedLightIn, packedOverlayIn);
                        stack.m_85849_();
                    }
                    bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                }
            } else if (armorForBone.m_41720_() instanceof BlockItem && ((BlockItem)armorForBone.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
                this.HEAD_QUEUE.add((Tuple<GeoBone, ItemStack>)new Tuple((Object)bone, (Object)armorForBone));
            }
        }
    }

    protected void handleGeoArmorBoneVisibility(GeoArmorRenderer<? extends GeoArmorItem> geoArmorRenderer, ModelPart sourceLimb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        IBone gbHead = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.headBone);
        IBone gbBody = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.bodyBone);
        IBone gbArmL = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.leftArmBone);
        IBone gbArmR = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.rightArmBone);
        IBone gbLegL = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.leftLegBone);
        IBone gbLegR = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.rightLegBone);
        IBone gbBootL = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.leftBootBone);
        IBone gbBootR = geoArmorRenderer.getGeoModelProvider().getBone(geoArmorRenderer.rightBootBone);
        gbHead.setHidden(true);
        gbBody.setHidden(true);
        gbArmL.setHidden(true);
        gbArmR.setHidden(true);
        gbLegL.setHidden(true);
        gbLegR.setHidden(true);
        gbBootL.setHidden(true);
        gbBootR.setHidden(true);
        if (sourceLimb == armorModel.f_102808_ || sourceLimb == armorModel.f_102809_) {
            gbHead.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102810_) {
            gbBody.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102812_) {
            gbArmL.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102814_) {
            if (slot == EquipmentSlot.FEET) {
                gbBootL.setHidden(false);
            } else {
                gbLegL.setHidden(false);
            }
            return;
        }
        if (sourceLimb == armorModel.f_102811_) {
            gbArmR.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102813_) {
            if (slot == EquipmentSlot.FEET) {
                gbBootR.setHidden(false);
            } else {
                gbLegR.setHidden(false);
            }
            return;
        }
    }

    protected void renderArmorOfItem(ArmorItem armorItem, ItemStack armorForBone, EquipmentSlot boneSlot, ResourceLocation armorResource, ModelPart sourceLimb, PoseStack stack, int packedLightIn, int packedOverlayIn) {
        if (armorItem instanceof DyeableArmorItem) {
            int i = ((DyeableArmorItem)armorItem).m_41121_(armorForBone);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, r, g, b, 1.0f, armorForBone, armorResource);
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, this.getArmorResource((Entity)this.currentEntity, armorForBone, boneSlot, "overlay"));
        } else {
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, armorResource);
        }
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack) {
        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, false, false);
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack, boolean geoArmor, boolean modMatrixRot) {
        GeoCube firstCube = (GeoCube)bone.childCubes.get(0);
        ModelPart.Cube armorCube = cubeList.get(0);
        float targetSizeX = firstCube.size.m_122239_();
        float targetSizeY = firstCube.size.m_122260_();
        float targetSizeZ = firstCube.size.m_122269_();
        float sourceSizeX = Math.abs(armorCube.f_104338_ - armorCube.f_104335_);
        float sourceSizeY = Math.abs(armorCube.f_104339_ - armorCube.f_104336_);
        float sourceSizeZ = Math.abs(armorCube.f_104340_ - armorCube.f_104337_);
        float scaleX = targetSizeX / sourceSizeX;
        float scaleY = targetSizeY / sourceSizeY;
        float scaleZ = targetSizeZ / sourceSizeZ;
        sourceLimb.m_104227_(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        if (!geoArmor) {
            sourceLimb.f_104203_ = -bone.getRotationX();
            sourceLimb.f_104204_ = -bone.getRotationY();
            sourceLimb.f_104205_ = bone.getRotationZ();
        } else {
            float xRot = -bone.getRotationX();
            xRot *= 2.0f;
            float yRot = -bone.getRotationY();
            yRot *= 2.0f;
            float zRot = bone.getRotationZ();
            zRot *= 2.0f;
            GeoBone tmpBone = bone.parent;
            while (tmpBone != null) {
                xRot -= tmpBone.getRotationX();
                yRot -= tmpBone.getRotationY();
                zRot += tmpBone.getRotationZ();
                tmpBone = tmpBone.parent;
            }
            if (modMatrixRot) {
                xRot = (float)Math.toRadians(xRot);
                yRot = (float)Math.toRadians(yRot);
                zRot = (float)Math.toRadians(zRot);
                stack.m_85845_(new Quaternion(0.0f, 0.0f, zRot, false));
                stack.m_85845_(new Quaternion(0.0f, yRot, 0.0f, false));
                stack.m_85845_(new Quaternion(xRot, 0.0f, 0.0f, false));
            } else {
                sourceLimb.f_104203_ = xRot;
                sourceLimb.f_104204_ = yRot;
                sourceLimb.f_104205_ = zRot;
            }
        }
        stack.m_85841_(scaleX, scaleY, scaleZ);
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ResourceLocation tfb = this.getCurrentModelRenderCycle() != software.bernie.geckolib3.util.EModelRenderCycle.INITIAL ? null : this.getTextureForBone(bone.getName(), this.currentAnimatable);
        boolean customTextureMarker = tfb != null;
        ResourceLocation currentTexture = this.m_5478_((Entity)this.currentEntity);
        if (customTextureMarker) {
            currentTexture = tfb;
            if (this.rtb != null) {
                RenderType rt = this.getRenderTypeForBone(bone, this.currentAnimatable, this.currentPartialTicks, stack, bufferIn, this.rtb, packedLightIn, currentTexture);
                bufferIn = this.rtb.m_6299_(rt);
            }
        }
        if (this.getCurrentModelRenderCycle() == software.bernie.geckolib3.util.EModelRenderCycle.INITIAL) {
            stack.m_85836_();
            if (this.isArmorBone(bone)) {
                stack.m_85836_();
                try {
                    this.handleArmorRenderingForBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, currentTexture);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                stack.m_85849_();
            } else {
                ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentAnimatable);
                BlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentAnimatable);
                if (boneItem != null || boneBlock != null) {
                    stack.m_85836_();
                    this.handleItemAndBlockBoneRendering(stack, bone, boneItem, boneBlock, packedLightIn, packedOverlayIn);
                    stack.m_85849_();
                    bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                }
            }
            stack.m_85849_();
        }
        this.customBoneSpecificRenderingHook(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, customTextureMarker, currentTexture);
        if (customTextureMarker) {
            bufferIn = this.currentVertexBuilderInUse;
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected void customBoneSpecificRenderingHook(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean customTextureMarker, ResourceLocation currentTexture) {
    }

    protected void handleItemAndBlockBoneRendering(PoseStack stack, GeoBone bone, @javax.annotation.Nullable ItemStack boneItem, @javax.annotation.Nullable BlockState boneBlock, int packedLightIn, int packedOverlayIn) {
        RenderUtils.translate((GeoBone)bone, (PoseStack)stack);
        RenderUtils.moveToPivot((GeoBone)bone, (PoseStack)stack);
        RenderUtils.rotate((GeoBone)bone, (PoseStack)stack);
        RenderUtils.scale((GeoBone)bone, (PoseStack)stack);
        RenderUtils.moveBackFromPivot((GeoBone)bone, (PoseStack)stack);
        this.moveAndRotateMatrixToMatchBone(stack, bone);
        if (boneItem != null) {
            this.preRenderItem(stack, boneItem, bone.getName(), this.currentAnimatable, (IBone)bone);
            this.renderItemStack(stack, this.rtb, packedLightIn, boneItem, bone.getName());
            this.postRenderItem(stack, boneItem, bone.getName(), this.currentAnimatable, (IBone)bone);
        }
        if (boneBlock != null) {
            this.preRenderBlock(stack, boneBlock, bone.getName(), this.currentAnimatable);
            this.renderBlock(stack, this.rtb, packedLightIn, boneBlock);
            this.postRenderBlock(stack, boneBlock, bone.getName(), this.currentAnimatable);
        }
    }

    protected void renderItemStack(PoseStack stack, MultiBufferSource rtb, int packedLightIn, ItemStack boneItem, String boneName) {
        Minecraft.m_91087_().m_91291_().m_174242_(this.currentEntity, boneItem, this.getCameraTransformForItemAtBone(boneItem, boneName), false, stack, rtb, null, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)this.currentEntity, (float)0.0f), this.currentEntity.m_142049_());
    }

    protected RenderType getRenderTypeForBone(GeoBone bone, T currentEntityBeingRendered2, float currentPartialTicks2, PoseStack stack, VertexConsumer bufferIn, MultiBufferSource currentRenderTypeBufferInUse2, int packedLightIn, ResourceLocation currentTexture) {
        return this.getRenderType(currentEntityBeingRendered2, currentPartialTicks2, stack, currentRenderTypeBufferInUse2, bufferIn, packedLightIn, currentTexture);
    }

    protected void renderArmorPart(PoseStack stack, ModelPart sourceLimb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, ItemStack armorForBone, ResourceLocation armorResource) {
        VertexConsumer ivb = ItemRenderer.m_115184_((MultiBufferSource)this.rtb, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)armorForBone.m_41790_());
        sourceLimb.m_104306_(stack, ivb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @javax.annotation.Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);

    protected void renderBlock(PoseStack matrixStack, MultiBufferSource rtb, int packedLightIn, BlockState iBlockState) {
        if (iBlockState.m_60799_() != RenderShape.MODEL) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.25, -0.25, -0.25);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91289_().m_110912_(iBlockState, matrixStack, rtb, packedLightIn, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
    }

    @javax.annotation.Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    protected abstract ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack var1, String var2);

    @javax.annotation.Nullable
    protected abstract BlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void preRenderBlock(PoseStack var1, BlockState var2, String var3, T var4);

    protected abstract void postRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void postRenderBlock(PoseStack var1, BlockState var2, String var3, T var4);

    @javax.annotation.Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        return null;
    }

    @javax.annotation.Nullable
    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        return null;
    }

    @javax.annotation.Nullable
    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        return null;
    }

    protected ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public static enum EModelRenderCycle implements IRenderCycle
    {
        INITIAL,
        REPEATED,
        SPECIAL;

    }

    public static interface IRenderCycle {
        public String name();
    }
}

