/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.data;

import com.infamous.dungeons_mobs.data.UniqueAncientData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public class MobAncientData {
    public static final List<String> defaultAdjectives = Arrays.asList("The Abominable", "The Wretched", "The Harrowing", "The Devastating", "The Ominous", "The Grim", "The Terrible");
    public static final List<String> defaultNouns = Arrays.asList("Calamity", "Abomination", "Terror", "Cataclysm", "Harbringer", "Catastrophe", "Disaster", "Torment");
    public static final List<ResourceLocation> defaultMinions = Arrays.asList(MobAncientData.mcLoc("slime"));
    public static final MobAncientData DEFAULT = new MobAncientData(defaultAdjectives, defaultNouns, defaultMinions, Arrays.asList(new UniqueAncientData[0]));
    public static final Codec<MobAncientData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.listOf().optionalFieldOf("adjectives", defaultAdjectives).forGetter(data -> data.adjectives), (App)Codec.STRING.listOf().optionalFieldOf("nouns", defaultNouns).forGetter(data -> data.nouns), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("minions", defaultMinions).forGetter(data -> data.minions), (App)UniqueAncientData.CODEC.listOf().optionalFieldOf("uniques", Arrays.asList(new UniqueAncientData[0])).forGetter(data -> data.uniques)).apply((Applicative)builder, MobAncientData::new));
    private final List<String> adjectives;
    private final List<String> nouns;
    private final List<ResourceLocation> minions;
    private final List<UniqueAncientData> uniques;

    public MobAncientData(List<String> adjectives, List<String> nouns, List<ResourceLocation> minions, List<UniqueAncientData> uniques) {
        this.adjectives = adjectives;
        this.nouns = nouns;
        this.minions = minions;
        this.uniques = uniques;
    }

    public List<String> getAdjectives() {
        return this.adjectives;
    }

    public List<String> getNouns() {
        return this.nouns;
    }

    public List<ResourceLocation> getMinions() {
        return this.minions;
    }

    public List<UniqueAncientData> getUniques() {
        return this.uniques;
    }

    public String getAncientName(Random random) {
        return this.adjectives.get(random.nextInt(this.adjectives.size())) + " " + this.nouns.get(random.nextInt(this.nouns.size()));
    }

    private static ResourceLocation mcLoc(String path) {
        return new ResourceLocation(path);
    }
}

