/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.blaze;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WildfireEntity
extends Monster
implements IAnimatable,
SpawnArmoredMob {
    private static final EntityDataAccessor<Integer> SHIELDS = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SHIELD_HEALTH = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Predicate<Entity> NO_BLAZE_AND_ALIVE = p_213685_0_ -> p_213685_0_.m_6084_() && !(p_213685_0_ instanceof Blaze) && !(p_213685_0_ instanceof WildfireEntity);
    public int shootAnimationTick;
    public int shootAnimationLength = 12;
    public int shootAnimationActionPoint = 5;
    public int shockwaveAnimationTick;
    public int shockwaveAnimationLength = 27;
    public int shockwaveAnimationActionPoint = 9;
    public int summonAnimationTick;
    public int summonAnimationLength = 47;
    public int summonAnimationActionPoint = 15;
    public int soundLoopTick;
    public int regenerateShieldTick;
    public int regenerateShieldTime = 150;
    public float individualShieldHealth = 15.0f;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public WildfireEntity(EntityType<? extends WildfireEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 25;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ShockwaveAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SummonBlazesGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ApproachTargetGoal((PathfinderMob)this, 10.0, 1.2, true));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(600));
    }

    private void shockwave() {
        if (this.m_6084_()) {
            for (Entity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_(5.0), NO_BLAZE_AND_ALIVE)) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 7.0f);
                entity.m_20254_(3);
                this.strongKnockback(entity);
            }
        }
    }

    private void strongKnockback(Entity p_213688_1_) {
        double d0 = p_213688_1_.m_20185_() - this.m_20185_();
        double d1 = p_213688_1_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.m_5997_(d0 / d2 * 3.0, 0.2, d1 / d2 * 3.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, SpawnGroupData p_213386_4_, CompoundTag p_213386_5_) {
        this.setShieldHealth(this.individualShieldHealth * 4.0f);
        this.setShields(4);
        this.m_6851_(p_213386_2_);
        this.m_6850_(p_213386_2_);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    protected void m_6851_(DifficultyInstance p_180481_1_) {
        super.m_6851_(p_180481_1_);
        SpawnArmoredHelper.equipArmorSet(ModItems.NETHERPLATE_ARMOR, (Mob)this);
    }

    public int getShields() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SHIELDS)), (int)0, (int)4);
    }

    public void setShields(int p_191997_1_) {
        this.f_19804_.m_135381_(SHIELDS, (Object)p_191997_1_);
    }

    public float getShieldHealth() {
        return ((Float)this.f_19804_.m_135370_(SHIELD_HEALTH)).floatValue();
    }

    public void setShieldHealth(float p_191997_1_) {
        this.f_19804_.m_135381_(SHIELD_HEALTH, (Object)Float.valueOf(p_191997_1_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELDS, (Object)0);
        this.f_19804_.m_135372_(SHIELD_HEALTH, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128405_("Shields", this.getShields());
        p_213281_1_.m_128350_("ShieldHealth", this.getShieldHealth());
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.setShields(p_70037_1_.m_128451_("Shields"));
        this.setShieldHealth(p_70037_1_.m_128457_("ShieldHealth"));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.getShields() > 0 && p_184601_1_ != DamageSource.f_19317_ && p_184601_1_ != DamageSource.f_19312_ ? SoundEvents.f_11704_ : (SoundEvent)ModSoundEvents.WILDFIRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_DEATH.get();
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_MOVE.get(), 0.15f, 1.0f);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 11) {
            this.shockwaveAnimationTick = this.shockwaveAnimationLength;
        } else if (p_28844_ == 9) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean causeFallDamage(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.getShields() > 0 && p_70097_1_ != DamageSource.f_19317_ && p_70097_1_ != DamageSource.f_19312_) {
            if (p_70097_1_.m_7639_() != null && p_70097_1_.m_7639_() instanceof LivingEntity) {
                this.m_6703_((LivingEntity)p_70097_1_.m_7639_());
            }
            this.setShieldHealth(this.getShieldHealth() - p_70097_2_);
            if (this.getShieldHealth() < this.individualShieldHealth * 3.0f && this.getShields() > 3 || this.getShieldHealth() < this.individualShieldHealth * 2.0f && this.getShields() > 2 || this.getShieldHealth() < this.individualShieldHealth * 1.0f && this.getShields() > 1 || this.getShieldHealth() <= this.individualShieldHealth * 0.0f && this.getShields() > 0) {
                this.breakShield();
            } else {
                this.m_6677_(p_70097_1_);
            }
            return false;
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    boolean steepDropBelow() {
        boolean blockBeneath = false;
        for (int i = 0; i < 8; ++i) {
            if (this.f_19853_.m_8055_(new BlockPos(this.m_142538_().m_123341_(), this.m_142538_().m_123342_() - i, this.m_142538_().m_123343_())).m_60795_()) continue;
            blockBeneath = true;
        }
        return !this.f_19853_.f_46443_ && !blockBeneath;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.getShields() < 4 && this.regenerateShieldTick > 0) {
            --this.regenerateShieldTick;
            if (this.regenerateShieldTick == 0) {
                this.regenerateShield();
            }
        }
        if (this.getShields() > 0 && this.getShieldHealth() <= 0.0f) {
            this.breakShield();
        }
        if (this.m_5448_() != null && (!this.m_20096_() && this.steepDropBelow() || this.m_5448_().m_20186_() > this.m_20186_() + 3.0 || this.m_20186_() < this.m_5448_().m_20186_() || this.m_20270_((Entity)this.m_5448_()) > 15.0f)) {
            if (this.m_20186_() < this.m_5448_().m_20186_() + 5.0) {
                this.m_20334_(0.0, 0.04, 0.0);
            } else {
                this.m_20334_(0.0, -0.01, 0.0);
            }
            double x = this.m_5448_().m_20185_() - this.m_20185_();
            double y = this.m_5448_().m_20186_() - this.m_20186_();
            double z = this.m_5448_().m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.m_20256_(this.m_20184_().m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(0.4));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_5448_().m_20185_(), this.m_5448_().m_20188_(), this.m_5448_().m_20189_()));
        }
        ++this.soundLoopTick;
        if (this.soundLoopTick % 100 == 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_IDLE_LOOP.get(), 0.5f, 1.0f);
        }
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.3, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public void breakShield() {
        this.regenerateShieldTick = this.regenerateShieldTime;
        this.setShields(this.getShields() - 1);
        this.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_SHIELD_BREAK.get(), 1.0f, 1.0f);
    }

    public void regenerateShield() {
        this.setShields(this.getShields() + 1);
        this.setShieldHealth(this.getShieldHealth() + this.individualShieldHealth);
        this.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_SHOOT.get(), 1.0f, 1.0f);
        this.regenerateShieldTick = this.regenerateShieldTime;
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.shockwaveAnimationTick > 0) {
            --this.shockwaveAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.shockwaveAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_shockwave", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ArmorSet getArmorSet() {
        return ModItems.NETHERPLATE_ARMOR;
    }

    class ShockwaveAttackGoal
    extends Goal {
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;

        public ShockwaveAttackGoal(WildfireEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20096_() && this.mob.f_19796_.nextInt(20) == 0 && this.mob.m_20270_((Entity)this.target) < 4.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_SHOCKWAVE.get(), 1.0f, this.mob.m_6100_());
            this.mob.shockwaveAnimationTick = this.mob.shockwaveAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.shockwaveAnimationTick == this.mob.shockwaveAnimationActionPoint) {
                this.mob.shockwave();
            }
        }

        public boolean animationsUseable() {
            return this.mob.shockwaveAnimationTick <= 0;
        }
    }

    class SummonBlazesGoal
    extends Goal {
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;
        public int blazeSummonRange = 5;
        public int closeBlazeSummonRange = 2;

        public SummonBlazesGoal(WildfireEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            Master master = MinionMasterHelper.getMasterCapability((Entity)this.mob);
            List summons = master.getSummonedMobs();
            AttributeInstance attribute = this.mob.m_21051_((Attribute)AttributeRegistry.SUMMON_CAP.get());
            return this.target != null && this.mob.f_19796_.nextInt(80 * (summons.size() + 1)) == 0 && attribute != null && (double)master.getSummonedMobsCost() < attribute.m_22135_() && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_MOVE.get(), 1.0f, this.mob.m_6100_());
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint) {
                for (int i = 0; i < 1 + this.mob.f_19796_.nextInt(1); ++i) {
                    SummonSpotEntity blazeSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                    blazeSummonSpot.mobSpawnRotation = this.mob.f_19796_.nextInt(360);
                    blazeSummonSpot.setSummonType(1);
                    BlockPos summonPos = this.mob.m_142538_().m_142082_(-this.blazeSummonRange + this.mob.f_19796_.nextInt(this.blazeSummonRange * 2 + 1), 0, -this.blazeSummonRange + this.mob.f_19796_.nextInt(this.blazeSummonRange * 2 + 1));
                    blazeSummonSpot.m_20035_(summonPos, 0.0f, 0.0f);
                    if (blazeSummonSpot.m_5830_() || !this.canSee(blazeSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.m_142538_().m_142082_(-this.closeBlazeSummonRange + this.mob.f_19796_.nextInt(this.closeBlazeSummonRange * 2 + 1), 0, -this.closeBlazeSummonRange + this.mob.f_19796_.nextInt(this.closeBlazeSummonRange * 2 + 1));
                    }
                    if (blazeSummonSpot.m_5830_() || !this.canSee(blazeSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.m_142538_();
                    }
                    ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)blazeSummonSpot);
                    PositionUtils.moveToCorrectHeight(blazeSummonSpot);
                    EntityType entityType = EntityType.f_20551_;
                    Mob summonedMob = null;
                    Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)blazeSummonSpot.m_142538_(), (EntityType)entityType);
                    if (entity == null) {
                        blazeSummonSpot.m_142687_(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    if (entity instanceof Mob) {
                        summonedMob = (Mob)entity;
                    }
                    summonedMob.m_6710_(this.target);
                    summonedMob.m_6518_((ServerLevelAccessor)((ServerLevel)this.mob.f_19853_), this.mob.f_19853_.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                    blazeSummonSpot.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                    if (this.mob.m_5647_() != null) {
                        Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                        scoreboard.m_6546_(summonedMob.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                    }
                    blazeSummonSpot.summonedEntity = summonedMob;
                }
            }
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vec3 vector3d = new Vec3(entitySeeing.m_20185_(), entitySeeing.m_20188_(), entitySeeing.m_20189_());
            Vec3 vector3d1 = new Vec3(p_70685_1_.m_20185_(), p_70685_1_.m_20188_(), p_70685_1_.m_20189_());
            if (p_70685_1_.f_19853_ != entitySeeing.f_19853_ || vector3d1.m_82557_(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySeeing)).m_6662_() == HitResult.Type.MISS;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public WildfireEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(WildfireEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19796_.nextInt(15) == 0 && this.mob.m_20270_((Entity)this.target) > 4.0f && this.mob.m_20270_((Entity)this.target) < 13.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                double d1 = this.target.m_20185_() - this.mob.m_20185_();
                double d2 = this.target.m_20227_(0.5) - this.mob.m_20227_(0.75);
                double d3 = this.target.m_20189_() - this.mob.m_20189_();
                SmallFireball smallfireballentity = new SmallFireball(this.mob.f_19853_, (LivingEntity)this.mob, d1, d2, d3);
                smallfireballentity.m_6034_(smallfireballentity.m_20185_(), this.mob.m_20227_(0.5) + 0.5, smallfireballentity.m_20189_());
                this.mob.f_19853_.m_7967_((Entity)smallfireballentity);
                this.mob.m_5496_((SoundEvent)ModSoundEvents.WILDFIRE_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }
}

