/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.UseShieldGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RoyalGuardEntity
extends AbstractIllager
implements IAnimatable,
IShieldUser,
SpawnArmoredMob {
    private static final UUID SPEED_MODIFIER_BLOCKING_UUID = UUID.fromString("05cd371b-0ff4-4ded-8630-b380232ed7b1");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_UUID, "Blocking speed decrease", -0.1, AttributeModifier.Operation.ADDITION);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int shieldCooldownTime = 0;
    public int attackAnimationTick;
    public int attackAnimationLength = 27;
    public int attackAnimationActionPoint = 15;

    public RoyalGuardEntity(Level world) {
        super((EntityType)ModEntityTypes.ROYAL_GUARD.get(), world);
    }

    public RoyalGuardEntity(EntityType<? extends RoyalGuardEntity> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new UseShieldGoal((PathfinderMob)this, 7.5, 60, 160, 15, 100, false));
        this.f_21345_.m_25352_(1, (Goal)new BasicAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ApproachTargetGoal((PathfinderMob)this, 0.0, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData ilivingentitydata = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_6851_(p_213386_2_);
        this.m_6850_(p_213386_2_);
        return ilivingentitydata;
    }

    public boolean m_21526_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_21254_()) {
            if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_BLOCKING)) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_BLOCKING);
            }
        } else {
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_BLOCKING);
        }
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21254_()) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_walk_blocking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_blocking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_((SoundEvent)ModSoundEvents.ROYAL_GUARD_STEP.get(), 0.5f, 1.0f);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Vindicator.m_34104_().m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22279_, (double)0.325f).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    protected void m_6851_(DifficultyInstance difficultyInstance) {
        SpawnArmoredHelper.equipArmorSet(ModItems.ROYAL_GUARD_ARMOR, (Mob)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            ItemStack mace = new ItemStack((ItemLike)MACE);
            if (this.m_37885_() == null) {
                this.m_8061_(EquipmentSlot.MAINHAND, mace);
            }
        } else if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        }
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ModItems.ROYAL_GUARD_SHIELD.get()));
    }

    public void m_7895_(int waveAmount, boolean b) {
        ItemStack mainhandWeapon = new ItemStack((ItemLike)Items.f_42386_);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            mainhandWeapon = new ItemStack((ItemLike)MACE);
        }
        Raid raid = this.m_37885_();
        int enchantmentLevel = 1;
        if (raid != null && waveAmount > raid.m_37724_(Difficulty.NORMAL)) {
            enchantmentLevel = 2;
        }
        boolean applyEnchant = false;
        if (raid != null) {
            boolean bl = applyEnchant = this.f_19796_.nextFloat() <= raid.m_37783_();
        }
        if (applyEnchant) {
            HashMap enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.f_44977_, enchantmentLevel);
            EnchantmentHelper.m_44865_((Map)enchantmentIntegerMap, (ItemStack)mainhandWeapon);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, mainhandWeapon);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        AbstractIllager.IllagerArmPose illagerArmPose = super.m_6768_();
        if (illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.f_19796_.nextFloat() < f) {
            this.shieldCooldownTime = 100;
            this.m_5810_();
            this.f_19853_.m_7605_((Entity)this, (byte)30);
        }
    }

    protected void m_6677_(DamageSource damageSource) {
        if (this.shieldCooldownTime == 100) {
            this.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
        } else if (this.m_21254_()) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
        } else {
            super.m_6677_(damageSource);
        }
    }

    public void m_6728_(LivingEntity livingEntity) {
        super.m_6728_(livingEntity);
        if (livingEntity.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void m_7909_(float amount) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && amount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)amount);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, royalGuardEntity -> royalGuardEntity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
            }
        }
    }

    public ArmorSet getArmorSet() {
        return ModItems.ROYAL_GUARD_ARMOR;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player && livingEntity.m_21254_()) {
            ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21120_(livingEntity.m_7655_()).m_41720_(), ticks);
            livingEntity.m_5810_();
            livingEntity.f_19853_.m_7605_((Entity)livingEntity, (byte)30);
        }
    }

    class BasicAttackGoal
    extends Goal {
        public RoyalGuardEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(RoyalGuardEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.mob.m_21254_() && (double)this.mob.m_20270_((Entity)this.target) <= 2.5 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.ROYAL_GUARD_ATTACK.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) < 3.5 && this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                this.mob.m_7327_((Entity)this.target);
                RoyalGuardEntity.disableShield(this.target, 60);
            }
        }

        public void m_8041_() {
            if (this.target != null && !this.isShieldDisabled((PathfinderMob)this.mob) && this.shouldBlockForTarget(this.target) && this.mob.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK) && this.mob.f_19796_.nextInt(6) == 0) {
                this.mob.m_6672_(InteractionHand.OFF_HAND);
            }
        }

        public boolean isShieldDisabled(PathfinderMob shieldUser) {
            return shieldUser instanceof IShieldUser && ((IShieldUser)shieldUser).isShieldDisabled();
        }

        public boolean shouldBlockForTarget(LivingEntity target) {
            return !(target instanceof Mob) || ((Mob)target).m_5448_() == this.mob;
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }
}

