/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.VinePartEntity;
import com.infamous.dungeons_mobs.tags.CustomTags;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractVineEntity
extends PathfinderMob
implements Enemy,
IAnimatable {
    public static final EntityDataAccessor<Integer> LENGTH = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> VANISHES = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> STAY_TIME = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ALWAYS_OUT = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHOULD_RETRACT = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DETECTION_DISTANCE = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> OUT = SynchedEntityData.m_135353_(AbstractVineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int lifeTime;
    public int burstAnimationTick;
    public int retractAnimationTick;
    private final Predicate<Entity> SHOULD_BURST_FOR = entity -> this.shouldBurstFor((Entity)entity);
    public VinePartEntity[] subEntities = new VinePartEntity[27];

    protected AbstractVineEntity(EntityType<? extends AbstractVineEntity> entityType, Level level) {
        super(entityType, level);
        int adjustedLength = 27;
        for (int i = 0; i < adjustedLength; ++i) {
            VinePartEntity newPart;
            this.subEntities[i] = newPart = new VinePartEntity(this, 26 - i);
        }
    }

    protected void updateParts() {
        for (VinePartEntity part : this.subEntities) {
            part.m_6210_();
            this.movePart(part, 0.0, part.getYOffsetForSegment(), 0.0);
        }
    }

    protected void movePart(VinePartEntity part, double dX, double dY, double dZ) {
        Vec3 lastPos = new Vec3(part.m_20185_(), part.m_20186_(), part.m_20189_());
        part.m_6034_(this.m_20185_() + dX, this.m_20186_() + dY, this.m_20189_() + dZ);
        part.f_19854_ = lastPos.f_82479_;
        part.f_19855_ = lastPos.f_82480_;
        part.f_19856_ = lastPos.f_82481_;
        part.f_19790_ = lastPos.f_82479_;
        part.f_19791_ = lastPos.f_82480_;
        part.f_19792_ = lastPos.f_82481_;
    }

    public void m_8107_() {
        super.m_8107_();
        this.updateParts();
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    protected int m_7302_(int p_70682_1_) {
        return p_70682_1_;
    }

    public boolean causeFallDamage(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (super.m_7307_(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).m_6095_().m_204039_(CustomTags.PLANT_MOBS)) {
            return this.m_5647_() == null && p_184191_1_.m_5647_() == null;
        }
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == this.getRetractAnimationLength()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LENGTH, (Object)0);
        this.f_19804_.m_135372_(VANISHES, (Object)false);
        this.f_19804_.m_135372_(STAY_TIME, (Object)0);
        this.f_19804_.m_135372_(ALWAYS_OUT, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RETRACT, (Object)false);
        this.f_19804_.m_135372_(DETECTION_DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(OUT, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLengthInSegments(compound.m_128451_("Length"));
        this.setVanishes(compound.m_128471_("Vanishes"));
        this.setStayTime(compound.m_128451_("StayTime"));
        this.setAlwaysOut(compound.m_128471_("AlwaysOut"));
        this.setShouldRetract(compound.m_128471_("ShouldRetract"));
        this.setDetectionDistance(compound.m_128457_("DetectionDistance"));
        this.setOut(compound.m_128471_("Out"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Length", this.getLengthInSegments());
        compound.m_128379_("Vanishes", this.getVanishes());
        compound.m_128405_("StayTime", this.getStayTime());
        compound.m_128379_("AlwaysOut", this.getAlwaysOut());
        compound.m_128379_("ShouldRetract", this.getShouldRetract());
        compound.m_128350_("DetectionDistance", this.getDetectionDistance());
        compound.m_128379_("Out", this.isOut());
    }

    public int getLengthInSegments() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(LENGTH)), (int)1, (int)26);
    }

    public float getLengthInPixels() {
        return this.getLengthInSegments() * 22;
    }

    public float getLengthInBlocks() {
        return this.getLengthInPixels() / 16.0f;
    }

    public void setLengthInSegments(int setTo) {
        this.f_19804_.m_135381_(LENGTH, (Object)setTo);
    }

    public void setLengthInPixels(int setTo) {
        this.setLengthInSegments(setTo / 22);
    }

    public void setLengthInBlocks(float setTo) {
        this.setLengthInPixels(Math.round(setTo * 16.0f));
    }

    public boolean getVanishes() {
        return (Boolean)this.f_19804_.m_135370_(VANISHES);
    }

    public void setVanishes(boolean setTo) {
        this.f_19804_.m_135381_(VANISHES, (Object)setTo);
    }

    public int getStayTime() {
        return (Integer)this.f_19804_.m_135370_(STAY_TIME);
    }

    public void setStayTime(int setTo) {
        this.f_19804_.m_135381_(STAY_TIME, (Object)setTo);
    }

    public boolean getAlwaysOut() {
        return (Boolean)this.f_19804_.m_135370_(ALWAYS_OUT);
    }

    public void setAlwaysOut(boolean setTo) {
        this.f_19804_.m_135381_(ALWAYS_OUT, (Object)setTo);
    }

    public boolean getShouldRetract() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RETRACT);
    }

    public void setShouldRetract(boolean setTo) {
        this.f_19804_.m_135381_(SHOULD_RETRACT, (Object)setTo);
    }

    public float getDetectionDistance() {
        return ((Float)this.f_19804_.m_135370_(DETECTION_DISTANCE)).floatValue();
    }

    public void setDetectionDistance(float setTo) {
        this.f_19804_.m_135381_(DETECTION_DISTANCE, (Object)Float.valueOf(setTo));
    }

    public boolean getOut() {
        return (Boolean)this.f_19804_.m_135370_(OUT);
    }

    public void setOut(boolean setTo) {
        this.f_19804_.m_135381_(OUT, (Object)setTo);
    }

    public abstract int getBurstAnimationLength();

    public abstract int getRetractAnimationLength();

    public float getExtraHitboxY() {
        return 0.0f;
    }

    public void m_8032_() {
        SoundEvent soundeventVocal = this.m_7515_();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_6677_(DamageSource p_184581_1_) {
        this.f_21363_ = -this.m_8100_();
        SoundEvent soundeventVocal = this.m_7975_(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    public void playBurstSound() {
        SoundEvent soundeventVocal = this.getBurstSound();
        SoundEvent soundeventFoley = this.getBurstSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    public void playRetractSound() {
        SoundEvent soundeventVocal = this.getRetractSound();
        SoundEvent soundeventFoley = this.getRetractSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.m_20067_()) {
            if (vocalSound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), vocalSound, this.m_5720_(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), foleySound, this.m_5720_(), foleyVolume, foleyPitch);
            }
        }
    }

    protected abstract SoundEvent getAmbientSoundFoley();

    protected abstract SoundEvent getHurtSoundFoley(DamageSource var1);

    public abstract SoundEvent getBurstSound();

    public abstract SoundEvent getRetractSound();

    public abstract SoundEvent getBurstSoundFoley();

    public abstract SoundEvent getRetractSoundFoley();

    protected float m_6121_() {
        return super.m_6121_() + (float)((double)this.getLengthInSegments() * 0.5);
    }

    public abstract int getAnimationTransitionTime();

    public boolean isOut() {
        return this.getOut();
    }

    public boolean canBurst() {
        return !this.isOut() && this.retractAnimationTick <= 0 && this.burstAnimationTick <= 0;
    }

    public boolean canRetract() {
        return this.isOut() && !this.getAlwaysOut() && this.retractAnimationTick <= 0 && this.burstAnimationTick <= 0;
    }

    public boolean shouldBurstFor(Entity entity) {
        return entity instanceof LivingEntity && !entity.m_6095_().m_204039_(CustomTags.PLANT_MOBS) && entity.m_6084_() && !entity.m_5833_() && (!(entity instanceof Player) || !((Player)entity).m_7500_());
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6052_() {
        return this.isOut();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_ == DamageSource.f_19317_ || this.isOut() && p_70097_1_ != DamageSource.f_19310_) {
            return super.m_6469_(p_70097_1_, p_70097_2_);
        }
        return false;
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public void m_7334_(Entity p_70108_1_) {
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    protected void m_6138_() {
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.burstAnimationTick = this.getBurstAnimationLength();
        } else if (p_70103_1_ == 11) {
            this.retractAnimationTick = this.getRetractAnimationLength();
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public EntityDimensions m_6972_(Pose p_213305_1_) {
        return !this.isOut() ? EntityDimensions.m_20395_((float)1.0f, (float)0.1f) : EntityDimensions.m_20395_((float)1.5f, (float)(this.getLengthInBlocks() + this.getExtraHitboxY()));
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public abstract void spawnAreaDamage();

    public abstract void setDefaultFeatures();

    public abstract boolean isKelp();

    public abstract boolean shouldDieInWrongHabitat();

    public abstract int wrongHabitatDieChance();

    public boolean isInWrongHabitat() {
        return this.isKelp() && !this.m_20072_() || !this.isKelp() && this.m_20072_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, SpawnGroupData p_213386_4_, CompoundTag p_213386_5_) {
        this.setDefaultFeatures();
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        this.tickDownAnimTimers();
        ++this.lifeTime;
        int nearbyEntities = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_((double)this.getDetectionDistance()), this.SHOULD_BURST_FOR).size();
        if (!this.f_19853_.f_46443_) {
            if (this.isInWrongHabitat() && this.f_19796_.nextInt(this.wrongHabitatDieChance()) == 0 && this.shouldDieInWrongHabitat() && this.isOut()) {
                this.m_6074_();
            }
            if (this.burstAnimationTick == 1) {
                this.setOut(true);
            } else if (this.retractAnimationTick == 1) {
                this.setOut(false);
            }
            if (this.getAlwaysOut() && this.canBurst()) {
                this.burst();
            }
            if (nearbyEntities > 0) {
                if (this.canBurst()) {
                    this.burst();
                }
            } else if (this.canRetract() && this.getShouldRetract()) {
                this.retract();
            }
            if (this.getVanishes() && this.lifeTime > this.getStayTime()) {
                if (this.retractAnimationTick <= 0) {
                    this.retract();
                }
                if (this.retractAnimationTick == 1) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public void burst() {
        this.spawnAreaDamage();
        this.playBurstSound();
        this.burstAnimationTick = this.getBurstAnimationLength();
        this.f_19853_.m_7605_((Entity)this, (byte)4);
    }

    public void retract() {
        this.spawnAreaDamage();
        this.playRetractSound();
        this.retractAnimationTick = this.getRetractAnimationLength();
        this.f_19853_.m_7605_((Entity)this, (byte)11);
    }

    public void tickDownAnimTimers() {
        if (this.burstAnimationTick > 0) {
            --this.burstAnimationTick;
        }
        if (this.retractAnimationTick > 0) {
            --this.retractAnimationTick;
        }
    }

    public void m_20234_(int p_145769_1_) {
        super.m_20234_(p_145769_1_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_145769_1_ + i + 1);
        }
    }
}

