/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.tags.CustomTags;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LeapleafEntity
extends Monster
implements IAnimatable {
    private static final UUID SPEED_MODIFIER_CHARGING_UUID = UUID.fromString("b380d5fd-85cb-4ac3-9450-d9092a09e0c9");
    private static final AttributeModifier SPEED_MODIFIER_CHARGING = new AttributeModifier(SPEED_MODIFIER_CHARGING_UUID, "Charging speed increase", 0.1, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> TIMES_LEAPT = SynchedEntityData.m_135353_(LeapleafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_LEAP = SynchedEntityData.m_135353_(LeapleafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(LeapleafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int strafeTick;
    public int strafeLength = 40;
    public int restTick;
    public int restLength = 100;
    public int attackAnimationTick;
    public int attackAnimationLength = 30;
    public int attackAnimationActionPoint = 15;
    public int prepareLeapAnimationTick;
    public int prepareLeapAnimationLength = 30;
    public int leapAnimationTick;
    public int leapAnimationLength = 9;
    public int smashAnimationTick;
    public int smashAnimationLength = 25;
    public int smashAnimationActionPoint = 18;
    public int leapCooldown;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public LeapleafEntity(Level world) {
        super((EntityType)ModEntityTypes.LEAPLEAF.get(), world);
    }

    public LeapleafEntity(EntityType<? extends LeapleafEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 20;
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        this.f_21345_.m_25352_(1, (Goal)new StrafeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PrepareLeapGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BasicAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)this, 0.0, 1.2, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean shouldBeStationary() {
        return this.restTick > 0;
    }

    public void m_8032_() {
        SoundEvent soundeventVocal = this.m_7515_();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_6677_(DamageSource p_184581_1_) {
        this.f_21363_ = -this.m_8100_();
        SoundEvent soundeventVocal = this.m_7975_(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.m_6121_(), this.m_6100_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
        this.m_5496_(this.getStepSoundFoley(), 0.5f, 1.0f);
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.m_20067_()) {
            if (vocalSound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), vocalSound, this.m_5720_(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), foleySound, this.m_5720_(), foleyVolume, foleyPitch);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_IDLE_VOCAL.get();
    }

    protected SoundEvent getAmbientSoundFoley() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_IDLE_FOLEY.get();
    }

    public int m_8100_() {
        return 250;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_HURT_VOCAL.get();
    }

    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_HURT_FOLEY.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_STEP_VOCAL.get();
    }

    protected SoundEvent getStepSoundFoley() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_STEP_FOLEY.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMES_LEAPT, (Object)0);
        this.f_19804_.m_135372_(CAN_LEAP, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
    }

    public int getTimesLeapt() {
        return (Integer)this.f_19804_.m_135370_(TIMES_LEAPT);
    }

    public void setTimesLeapt(int attached) {
        this.f_19804_.m_135381_(TIMES_LEAPT, (Object)attached);
    }

    public boolean canLeap() {
        return (Boolean)this.f_19804_.m_135370_(CAN_LEAP);
    }

    public void setCanLeap(boolean attached) {
        this.f_19804_.m_135381_(CAN_LEAP, (Object)attached);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean attached) {
        this.f_19804_.m_135381_(LEAPING, (Object)attached);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else if (p_28844_ == 8) {
            this.prepareLeapAnimationTick = this.prepareLeapAnimationLength;
        } else if (p_28844_ == 9) {
            this.leapAnimationTick = this.leapAnimationLength;
        } else if (p_28844_ == 11) {
            this.smashAnimationTick = this.smashAnimationLength;
        } else if (p_28844_ == 7) {
            this.restTick = this.restLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        super.m_6075_();
        this.tickDownAnimTimers();
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (!this.f_19853_.f_46443_ && this.canLeap() && (this.m_5448_() == null || this.m_5448_().m_21224_())) {
            this.restTick = this.restLength;
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            this.setCanLeap(false);
            this.setTimesLeapt(0);
        }
        if (this.canLeap()) {
            if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_CHARGING)) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_CHARGING);
            }
        } else {
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_CHARGING);
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.nextInt(3) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.DUST.get(), this.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), (double)this.f_19796_.nextFloat() * 0.5, this.f_19796_.nextGaussian() * 1.0, this.f_19796_.nextGaussian() * 1.0);
        }
        if (this.restTick > 0) {
            --this.restTick;
        }
        if (this.strafeTick > 0) {
            --this.strafeTick;
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.prepareLeapAnimationTick > 0) {
            --this.prepareLeapAnimationTick;
        }
        if (this.leapAnimationTick > 0) {
            --this.leapAnimationTick;
        }
        if (this.smashAnimationTick > 0) {
            --this.smashAnimationTick;
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.smashAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_smash", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.leapAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_leap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.prepareLeapAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_prepare_leap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.restTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_rest", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isLeaping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_leaping", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (super.m_7307_(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).m_6095_().m_204039_(CustomTags.PLANT_MOBS)) {
            return this.m_5647_() == null && p_184191_1_.m_5647_() == null;
        }
        return false;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return LeapleafEntity.this.shouldBeStationary();
        }
    }

    class StrafeGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;
        private boolean strafingLeft;

        public StrafeGoal(LeapleafEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.strafeTick > 0;
        }

        public boolean m_8045_() {
            return this.target != null && this.mob.strafeTick > 0;
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                if (this.mob.f_19796_.nextInt(30) == 0) {
                    boolean bl = this.strafingLeft = !this.strafingLeft;
                }
                if (this.mob.m_20270_((Entity)this.target) < 4.0f) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(PositionUtils.getOffsetMotion((Entity)this.mob, 0.0, 0.0, -0.1, this.mob.f_20883_)));
                }
                if (this.strafingLeft) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(PositionUtils.getOffsetMotion((Entity)this.mob, 0.05, 0.0, 0.0, this.mob.f_20883_)));
                } else {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(PositionUtils.getOffsetMotion((Entity)this.mob, -0.05, 0.0, 0.0, this.mob.f_20883_)));
                }
            }
        }
    }

    class LeapGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;
        public int leapTime;

        public LeapGoal(LeapleafEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20270_((Entity)this.target) <= 10.0f && this.mob.canLeap() && this.mob.f_19796_.nextInt(5) == 0 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && (!this.animationsUseable() || this.mob.isLeaping() || this.mob.smashAnimationTick > 0);
        }

        public void m_8056_() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_LEAP_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_LEAP_FOLEY.get(), 1.5f, 1.0f, 1.5f, 1.0f);
            this.mob.leapAnimationTick = this.mob.leapAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null && this.mob.leapAnimationTick == 1) {
                double d0 = this.target.m_20185_() - this.mob.m_20185_();
                double d1 = this.target.m_20186_() - this.mob.m_20186_();
                double d2 = this.target.m_20189_() - this.mob.m_20189_();
                this.mob.m_20334_(d0 * 0.15, 0.75 + Mth.m_14008_((double)(d1 * 0.05), (double)0.0, (double)10.0), d2 * 0.15);
                this.mob.setLeaping(true);
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                this.leapTime = 0;
            }
            if (this.mob.isLeaping()) {
                ++this.leapTime;
            }
            if (this.mob.isLeaping() && this.mob.m_20096_() && this.leapTime > 10) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.LEAPLEAF_LAND.get(), 2.0f, 1.0f);
                this.mob.setLeaping(false);
                this.mob.smashAnimationTick = this.mob.smashAnimationLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
            }
            if (this.mob.smashAnimationTick == this.mob.smashAnimationActionPoint) {
                Vec3 areaDamagePos = PositionUtils.getOffsetPos((Entity)this.mob, -1.5, 0.0, 2.0, this.mob.f_20883_);
                AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.mob.f_19853_, areaDamagePos, (LivingEntity)this.mob, 25.0f, DamageSource.m_19370_((LivingEntity)this.mob), 0.0f, 6.0f, 1.0f, 0.75f, 10, false, false, 2.0, 0.4, true, 120, 1);
                Vec3 areaDamagePos2 = PositionUtils.getOffsetPos((Entity)this.mob, 1.5, 0.0, 2.0, this.mob.f_20883_);
                AreaDamageEntity areaDamage2 = AreaDamageEntity.spawnAreaDamage(this.mob.f_19853_, areaDamagePos2, (LivingEntity)this.mob, 25.0f, DamageSource.m_19370_((LivingEntity)this.mob), 0.0f, 6.0f, 1.0f, 0.75f, 10, false, false, 2.0, 0.4, true, 120, 1);
                areaDamage.connectedAreaDamages.add(areaDamage2);
                areaDamage2.connectedAreaDamages.add(areaDamage);
                this.mob.f_19853_.m_7967_((Entity)areaDamage);
                this.mob.f_19853_.m_7967_((Entity)areaDamage2);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.leapTime = 0;
            this.mob.setCanLeap(false);
            this.mob.setLeaping(false);
            this.mob.setTimesLeapt(this.mob.getTimesLeapt() + 1);
            this.mob.leapCooldown = 60;
            int leapTimesByDifficulty = this.mob.f_19853_.m_6436_(this.mob.m_142538_()).m_19048_().m_19028_();
            if (this.mob.getTimesLeapt() >= leapTimesByDifficulty) {
                this.mob.restTick = this.mob.restLength;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
                this.mob.setTimesLeapt(0);
                this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_REST_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_REST_FOLEY.get(), 1.0f, this.mob.m_6100_(), 1.0f, this.mob.m_6100_());
            } else {
                this.mob.strafeTick = this.mob.strafeLength;
            }
        }

        public boolean animationsUseable() {
            return this.mob.leapAnimationTick <= 0;
        }
    }

    class PrepareLeapGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;

        public PrepareLeapGoal(LeapleafEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_20270_((Entity)this.target) <= 15.0f && !this.mob.canLeap() && this.mob.f_19796_.nextInt(30) == 0 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.leapCooldown <= 0;
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_PREPARE_LEAP_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_PREPARE_LEAP_FOLEY.get(), 1.25f, 1.0f, 1.25f, 1.0f);
            this.mob.prepareLeapAnimationTick = this.mob.prepareLeapAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)8);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.mob.prepareLeapAnimationTick == 1) {
                this.mob.setCanLeap(true);
            }
        }

        public boolean animationsUseable() {
            return this.mob.prepareLeapAnimationTick <= 0;
        }
    }

    class BasicAttackGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(LeapleafEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 3.25 && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_ATTACK_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_ATTACK_FOLEY.get(), 1.25f, 1.0f, 1.25f, 1.0f);
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                Vec3 areaDamagePos = PositionUtils.getOffsetPos((Entity)this.mob, -1.0, 0.0, 1.5, this.mob.f_20883_);
                AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.mob.f_19853_, areaDamagePos, (LivingEntity)this.mob, 15.0f, DamageSource.m_19370_((LivingEntity)this.mob), 0.0f, 4.5f, 1.0f, 0.5f, 0, false, false, 1.0, 0.2, false, 0, 1);
                this.mob.f_19853_.m_7967_((Entity)areaDamage);
            }
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }
}

