/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.entities.summonables.SimpleTrapEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CobwebProjectileEntity
extends Projectile
implements IAnimatable {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public boolean delayedSpawnParticles;

    public CobwebProjectileEntity(EntityType<? extends CobwebProjectileEntity> p_i50162_1_, Level p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public CobwebProjectileEntity(Level p_i47273_1_, LivingEntity p_i47273_2_) {
        this((EntityType<? extends CobwebProjectileEntity>)((EntityType)ModEntityTypes.COBWEB_PROJECTILE.get()), p_i47273_1_);
        super.m_5602_((Entity)p_i47273_2_);
        this.m_6034_(p_i47273_2_.m_20185_() - (double)(p_i47273_2_.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14031_((float)(p_i47273_2_.f_20883_ * ((float)Math.PI / 180))), p_i47273_2_.m_20188_() - (double)0.1f, p_i47273_2_.m_20189_() + (double)(p_i47273_2_.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14089_((float)(p_i47273_2_.f_20883_ * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public CobwebProjectileEntity(Level p_i47274_1_, double p_i47274_2_, double p_i47274_4_, double p_i47274_6_, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        this((EntityType<? extends CobwebProjectileEntity>)((EntityType)ModEntityTypes.COBWEB_PROJECTILE.get()), p_i47274_1_);
        this.m_6034_(p_i47274_2_, p_i47274_4_, p_i47274_6_);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            p_i47274_1_.m_7106_((ParticleOptions)ParticleTypes.f_123764_, p_i47274_2_, p_i47274_4_, p_i47274_6_, p_i47274_8_ * d0, p_i47274_10_, p_i47274_12_ * d0);
        }
        this.m_20334_(p_i47274_8_, p_i47274_10_, p_i47274_12_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.delayedSpawnParticles) {
            this.delayedSpawnParticles = false;
            this.createSpawnParticles();
        }
        Vec3 vector3d = this.m_20184_();
        HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_(raytraceresult);
        }
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.m_37283_();
        float f = 0.99f;
        float f1 = 0.06f;
        if (this.f_19853_.m_45556_(this.m_142469_()).noneMatch(BlockBehaviour.BlockStateBase::m_60795_)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (this.m_20072_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.m_20256_(vector3d.m_82490_((double)f));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-f1), 0.0));
            }
            this.m_6034_(d0, d1, d2);
        }
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
        Entity entity = this.m_37282_();
        if (!(p_213868_1_.m_82443_() instanceof LivingEntity) || ((LivingEntity)p_213868_1_.m_82443_()).m_6336_() != MobType.f_21642_) {
            if (entity instanceof LivingEntity) {
                p_213868_1_.m_82443_().m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)entity)).m_19366_(), 1.0f);
            }
            if (!this.f_19853_.f_46443_) {
                this.spawnTrap(p_213868_1_.m_82443_().m_20185_(), p_213868_1_.m_82443_().m_20186_(), p_213868_1_.m_82443_().m_20189_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void createSpawnParticles() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        } else {
            for (int i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            for (int i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        if (!this.f_19853_.f_46443_) {
            this.spawnTrap(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void spawnTrap(double x, double y, double z) {
        SimpleTrapEntity trap = (SimpleTrapEntity)((EntityType)ModEntityTypes.SIMPLE_TRAP.get()).m_20615_(this.f_19853_);
        trap.m_6027_(x, y, z);
        trap.owner = this.m_37282_();
        this.f_19853_.m_7967_((Entity)trap);
        this.m_5496_((SoundEvent)ModSoundEvents.SPIDER_WEB_IMPACT.get(), 1.0f, 1.0f);
    }

    protected void m_8097_() {
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("web_projectile_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

