/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.google.common.base.MoreObjects;
import com.infamous.dungeons_mobs.entities.projectiles.StraightMovingProjectileEntity;
import com.infamous.dungeons_mobs.mod.ModDamageSources;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class PoisonQuillEntity
extends StraightMovingProjectileEntity
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> KELP = SynchedEntityData.m_135353_(PoisonQuillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public PoisonQuillEntity(Level worldIn) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.POISON_QUILL.get()), worldIn);
    }

    public PoisonQuillEntity(EntityType<? extends PoisonQuillEntity> p_i50147_1_, Level p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
    }

    public PoisonQuillEntity(Level p_i1794_1_, LivingEntity p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.POISON_QUILL.get()), p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_, p_i1794_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public PoisonQuillEntity(Level p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.POISON_QUILL.get()), p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    @Override
    public double getSpawnParticlesY() {
        return 0.2;
    }

    @Override
    public boolean slowedDownInWater() {
        return !this.isKelp();
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
    }

    @Override
    public void playImpactSound() {
        this.m_5496_((SoundEvent)ModSoundEvents.JUNGLE_ZOMBIE_STEP.get(), 0.75f, 1.0f + this.f_19796_.nextFloat() * 0.5f);
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!this.f_19853_.f_46443_) {
            super.onHitEntity(entity);
            boolean flag = entity.m_6469_(ModDamageSources.poisonQuill(this, (Entity)MoreObjects.firstNonNull((Object)this.m_37282_(), (Object)((Object)this))), 5.0f);
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 8;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 16;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0));
                }
            }
            if (flag && entity.m_6084_() && this.m_37282_() != null && this.m_37282_() instanceof LivingEntity) {
                this.m_19970_((LivingEntity)this.m_37282_(), entity);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(KELP, (Object)false);
    }

    public boolean isKelp() {
        return (Boolean)this.f_19804_.m_135370_(KELP);
    }

    public void setKelp(boolean p_82343_1_) {
        this.f_19804_.m_135381_(KELP, (Object)p_82343_1_);
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public boolean getsStuckInBlocks() {
        return true;
    }

    @Override
    public SoundEvent getImpactSound() {
        return null;
    }
}

