/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SlimeballEntity
extends AbstractHurtingProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(SlimeballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public SlimeballEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), worldIn);
    }

    public SlimeballEntity(EntityType<? extends SlimeballEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SlimeballEntity(Level world, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), x, y, z, accelX, accelY, accelZ, world);
    }

    public SlimeballEntity(Level world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), shooter, accelX, accelY, accelZ, world);
    }

    public void setStack(ItemStack stack) {
        if (stack.m_41720_() != Items.f_42518_ || stack.m_41782_()) {
            this.m_20088_().m_135381_(STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
        }
    }

    protected ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(STACK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getStack();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42518_) : itemstack;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack itemstack = this.getStack();
        if (!itemstack.m_41619_()) {
            compound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.setStack(itemstack);
    }

    protected boolean m_5931_() {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123753_;
    }

    protected void m_5790_(EntityHitResult rayTraceResult) {
        super.m_5790_(rayTraceResult);
        Entity entity = rayTraceResult.m_82443_();
        int attackDamage = 3;
        if (!(entity instanceof Slime)) {
            entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), (float)attackDamage);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (result instanceof EntityHitResult) {
            EntityHitResult entityRayTraceResult = (EntityHitResult)result;
            if (!(entityRayTraceResult.m_82443_() instanceof Slime) && !this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.removeIfWorldNotRemote();
        }
    }

    private void removeIfWorldNotRemote() {
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

