/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GeomancerBombEntity
extends ConstructEntity
implements IAnimatable {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private float explosionRadius = 3.0f;

    public GeomancerBombEntity(Level worldIn) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()), worldIn);
    }

    public GeomancerBombEntity(Level worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()), worldIn, x, y, z, casterIn, lifeTicksIn);
    }

    public GeomancerBombEntity(EntityType<? extends GeomancerBombEntity> explodingPillarEntityEntityType, Level world) {
        super(explodingPillarEntityEntityType, world);
    }

    @Override
    public void handleExpiration() {
        super.handleExpiration();
        if (!this.f_19853_.f_46443_) {
            this.explode();
        }
    }

    private void explode() {
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.explosionRadius, Explosion.BlockInteraction.NONE);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLifeTicks() > 75) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_appear", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

