/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GeomancerWallEntity
extends ConstructEntity
implements IAnimatable {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public GeomancerWallEntity(Level world) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), world);
    }

    public GeomancerWallEntity(EntityType<? extends GeomancerWallEntity> entityType, Level world) {
        super(entityType, world);
    }

    public GeomancerWallEntity(Level worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), worldIn, x, y, z, casterIn, lifeTicksIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.getLifeTicks() == 100) {
            this.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_WALL_SPAWN.get(), 1.0f, 1.0f);
        }
        if (this.getLifeTicks() == 40) {
            this.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_WALL_DESPAWN.get(), 1.0f, 1.0f);
        }
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLifeTicks() <= 100) {
            if (this.getLifeTicks() < 40) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_disappear", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            } else if (this.getLifeTicks() > 75) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_appear", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

