/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.mod.ModDamageSources;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TridentStormEntity
extends Entity
implements IAnimatable,
IAnimationTickable {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int lifeTime;
    public Entity owner;

    public TridentStormEntity(EntityType<? extends TridentStormEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate));
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("trident_storm_strike", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), Entity::m_6084_);
        if (!list.isEmpty() && !this.f_19853_.f_46443_) {
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.lifeTime < 80 || this.lifeTime > 90) continue;
                if (this.owner != null) {
                    if (livingEntity == this.owner) continue;
                    livingEntity.m_6469_(ModDamageSources.summonedTridentStorm(this, this.owner), 20.0f);
                    continue;
                }
                livingEntity.m_6469_(ModDamageSources.tridentStorm(this), 20.0f);
            }
        }
        ++this.lifeTime;
        if (this.lifeTime == 80) {
            this.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_TRIDENT_STORM_HIT.get(), 3.0f, 1.0f);
        }
        if (this.lifeTime >= 500 && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

