/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WraithFireEntity
extends Entity
implements IAnimatable,
IAnimationTickable {
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.m_6084_();
    public int lifeTime;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public Entity owner;
    public int textureChange = 0;

    public WraithFireEntity(EntityType<? extends WraithFireEntity> type, Level world) {
        super(type, world);
    }

    public void m_6075_() {
        super.m_6075_();
        ++this.lifeTime;
        ++this.textureChange;
        this.m_5618_(0.0f);
        if (this.lifeTime == 1) {
            this.m_5496_((SoundEvent)ModSoundEvents.WRAITH_FIRE.get(), 1.25f, this.f_19796_.nextFloat() * 0.7f + 0.3f);
        }
        if (this.f_19796_.nextInt(24) == 0 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11936_, this.m_5720_(), 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
        }
        double particleOffsetAmount = 1.25;
        if (this.isBurning()) {
            for (double x = -particleOffsetAmount; x < particleOffsetAmount * 2.0; x += particleOffsetAmount) {
                for (double z = -particleOffsetAmount; z < particleOffsetAmount * 2.0; z += particleOffsetAmount) {
                    if (this.f_19796_.nextInt(10) == 0) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + x, this.m_20186_(), this.m_20189_() + z, this.f_19796_.nextGaussian() * 0.01, 0.1, this.f_19796_.nextGaussian() * 0.01);
                    }
                    if (this.f_19796_.nextInt(5) != 0) continue;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + x, this.m_20186_(), this.m_20189_() + z, this.f_19796_.nextGaussian() * 0.01, 0.15, this.f_19796_.nextGaussian() * 0.01);
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            List list;
            if (this.m_20072_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
            if (this.m_20285_() && this.f_19796_.nextInt(40) == 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
            if (this.lifeTime >= 82) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.isBurning() && !(list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), ALIVE)).isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity) || !this.canHarmEntity((Entity)((LivingEntity)entity))) continue;
                    entity.m_6469_(DamageSource.f_19305_, 4.0f);
                    entity.m_20254_(4);
                }
            }
        }
    }

    public boolean m_20285_() {
        BlockPos blockpos = this.m_142538_();
        return this.f_19853_.m_46758_(blockpos) || this.f_19853_.m_46758_(new BlockPos((double)blockpos.m_123341_(), this.m_142469_().f_82292_, (double)blockpos.m_123343_()));
    }

    public boolean isBurning() {
        return this.lifeTime >= 20 && this.lifeTime <= 70;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_fire_burn", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean canHarmEntity(Entity target) {
        return this.owner != null && this.owner instanceof Mob ? ((Mob)this.owner).m_5448_() == target : !target.m_5825_();
    }
}

