/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.projectiles.NecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NecromancerEntity
extends Skeleton
implements IAnimatable,
SpawnArmoredMob {
    public int shootAnimationTick;
    public int shootAnimationLength = 20;
    public int shootAnimationActionPoint = 7;
    public int summonAnimationTick;
    public int summonAnimationLength = 45;
    public int summonAnimationActionPoint1 = this.summonAnimationLength - 20;
    public int summonAnimationActionPoint2 = this.summonAnimationLength - 23;
    public int summonAnimationActionPoint3 = this.summonAnimationLength - 26;
    public int summonAnimationActionPoint4 = this.summonAnimationLength - 32;
    public int summonAnimationActionPoint5 = this.summonAnimationLength - 38;
    public int specialAnimationTick;
    public int specialAnimationLength = 48;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public NecromancerEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.NECROMANCER.get(), worldIn);
    }

    public NecromancerEntity(EntityType<? extends NecromancerEntity> p_i48555_1_, Level p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
        this.f_21364_ = 20;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Skeleton.m_32166_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SummonGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ApproachTargetGoal((PathfinderMob)this, 10.0, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.2, 1.6));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 5.0f, 1.2, 1.6));
        this.f_21345_.m_25352_(4, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean isSpellcasting() {
        return this.shootAnimationTick > 0 || this.summonAnimationTick > 0;
    }

    public void m_32164_() {
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 2.25f;
    }

    protected boolean m_21527_() {
        return false;
    }

    protected void m_6851_(DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.NECROMANCER_STAFF.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.NECROMANCER_ARMOR, (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityDataIn, @Nullable CompoundTag compoundNBT) {
        livingEntityDataIn = super.m_6518_(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        return livingEntityDataIn;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.NECROMANCER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_DEATH.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_STEP.get();
    }

    public boolean m_21526_() {
        return false;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.specialAnimationTick = this.specialAnimationLength;
        } else if (p_28844_ == 11) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 9) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && this.f_19796_.nextInt(300) == 0) {
            this.specialAnimationTick = this.specialAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_LAUGH.get(), this.m_6121_(), this.m_6100_());
        }
        if (!(this.f_19853_.f_46443_ || this.m_5448_() == null || this.f_19796_.nextInt(100) != 0 && this.m_5448_().f_20919_ <= 0)) {
            this.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_LAUGH.get(), this.m_6121_(), this.m_6100_());
            this.f_21363_ = -this.m_8100_() / 2;
        }
    }

    public void tickDownAnimTimers() {
        if (this.specialAnimationTick > 0) {
            --this.specialAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.specialAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_rare_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ArmorSet getArmorSet() {
        return ModItems.NECROMANCER_ARMOR;
    }

    class SummonGoal
    extends Goal {
        public NecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 3;
        public int closeMobSummonRange = 1;

        public SummonGoal(NecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) > 5.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), 1.0f, 1.0f);
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && (this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint1 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint2 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint3 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint4 && this.mob.f_19796_.nextBoolean() || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint5 && this.mob.f_19796_.nextBoolean())) {
                SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                mobSummonSpot.mobSpawnRotation = this.mob.f_19796_.nextInt(360);
                mobSummonSpot.setSummonType(2);
                BlockPos summonPos = this.mob.m_142538_().m_142082_(-this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1));
                mobSummonSpot.m_20035_(summonPos, 0.0f, 0.0f);
                if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.m_142538_().m_142082_(-this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1));
                }
                if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.m_142538_();
                }
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)mobSummonSpot);
                PositionUtils.moveToCorrectHeight(mobSummonSpot);
                EntityType<?> entityType = this.getEntityType();
                Mob summonedMob = null;
                Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.m_142538_(), entityType);
                if (entity == null) {
                    mobSummonSpot.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                if (entity instanceof Mob) {
                    summonedMob = (Mob)entity;
                }
                summonedMob.m_6710_(this.target);
                summonedMob.m_6518_((ServerLevelAccessor)((ServerLevel)this.mob.f_19853_), this.mob.f_19853_.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                mobSummonSpot.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                if (this.mob.m_5647_() != null) {
                    Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                    scoreboard.m_6546_(summonedMob.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                }
                mobSummonSpot.summonedEntity = summonedMob;
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.m_21187_().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.f_20501_;
            }
            return entityType;
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (200 + this.mob.f_19796_.nextInt(200));
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vec3 vector3d = new Vec3(entitySeeing.m_20185_(), entitySeeing.m_20188_(), entitySeeing.m_20189_());
            Vec3 vector3d1 = new Vec3(p_70685_1_.m_20185_(), p_70685_1_.m_20188_(), p_70685_1_.m_20189_());
            if (p_70685_1_.f_19853_ != entitySeeing.f_19853_ || vector3d1.m_82557_(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySeeing)).m_6662_() == HitResult.Type.MISS;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public NecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(NecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.mob.m_20270_((Entity)this.target) > 5.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.f_20883_);
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                NecromancerOrbEntity necromancerOrb = new NecromancerOrbEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1, d2, d3);
                necromancerOrb.setDelayedForm(true);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                this.mob.f_19853_.m_7967_((Entity)necromancerOrb);
                this.mob.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }
}

