/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.projectiles.DrownedNecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.projectiles.NecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.entities.summonables.TridentStormEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DrownedNecromancerEntity
extends Drowned
implements IAnimatable,
SpawnArmoredMob {
    public int landShootAnimationTick;
    public int landShootAnimationLength = 20;
    public int landShootAnimationActionPoint = 7;
    public int landSummonAnimationTick;
    public int landSummonAnimationLength = 45;
    public int landSummonAnimationActionPoint1 = this.landSummonAnimationLength - 20;
    public int landSummonAnimationActionPoint2 = this.landSummonAnimationLength - 23;
    public int landSummonAnimationActionPoint3 = this.landSummonAnimationLength - 26;
    public int landSummonAnimationActionPoint4 = this.landSummonAnimationLength - 32;
    public int landSummonAnimationActionPoint5 = this.landSummonAnimationLength - 38;
    public int rainTridentStormAnimationTick;
    public int rainTridentStormAnimationLength = 45;
    public int rainShootAnimationTick;
    public int rainShootAnimationLength = 40;
    public int rainShootAnimationActionPoint = 23;
    public int summonAnimationTick;
    public int summonAnimationLength = 45;
    public int summonAnimationActionPoint = 23;
    public int shootAnimationTick;
    public int shootAnimationLength = 40;
    public int shootAnimationActionPoint = 23;
    public int tridentStormAnimationTick;
    public int tridentStormAnimationLength = 45;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public DrownedNecromancerEntity(EntityType<? extends DrownedNecromancerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Drowned.m_34328_().m_22268_(Attributes.f_22279_, 0.2).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.5).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22284_, 12.5).m_22268_(Attributes.f_22278_, 0.6).m_22268_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new LandSummonGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SummonGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TridentStormGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RainTridentStormGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RainShootAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LandShootAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)this, 7.5, 1.1, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new GoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new SwimUpGoal(this, 1.0, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public boolean isSpellcasting() {
        return this.shootAnimationTick > 0 || this.rainShootAnimationTick > 0 || this.landShootAnimationTick > 0 || this.tridentStormAnimationTick > 0 || this.rainTridentStormAnimationTick > 0 || this.summonAnimationTick > 0 || this.landSummonAnimationTick > 0;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 2.4f;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.landShootAnimationTick > 0) {
            --this.landShootAnimationTick;
        }
        if (this.landSummonAnimationTick > 0) {
            --this.landSummonAnimationTick;
        }
        if (this.rainTridentStormAnimationTick > 0) {
            --this.rainTridentStormAnimationTick;
        }
        if (this.rainShootAnimationTick > 0) {
            --this.rainShootAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.tridentStormAnimationTick > 0) {
            --this.tridentStormAnimationTick;
        }
    }

    public boolean m_21526_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 11) {
            this.landShootAnimationTick = this.landShootAnimationLength;
        } else if (p_28844_ == 9) {
            this.landSummonAnimationTick = this.landSummonAnimationLength;
        } else if (p_28844_ == 4) {
            this.rainTridentStormAnimationTick = this.rainTridentStormAnimationLength;
        } else if (p_28844_ == 8) {
            this.rainShootAnimationTick = this.rainShootAnimationLength;
        } else if (p_28844_ == 7) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else if (p_28844_ == 6) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 5) {
            this.tridentStormAnimationTick = this.tridentStormAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    protected boolean m_5884_() {
        return false;
    }

    public float m_6100_() {
        return !this.m_20069_() ? super.m_6100_() / 1.5f : super.m_6100_();
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_IDLE.get() : SoundEvents.f_11815_;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_HURT.get() : SoundEvents.f_11819_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_DEATH.get() : SoundEvents.f_11817_;
    }

    protected SoundEvent m_7660_() {
        return SoundEvents.f_11875_;
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SWIM.get();
    }

    protected void m_6851_(DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.NECROMANCER_TRIDENT.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.DROWNED_NECROMANCER_ARMOR, (Mob)this);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.tridentStormAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_trident_storm", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.rainTridentStormAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_trident_storm_land", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.landSummonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.rainShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_shoot_land", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.landShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.m_20069_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private boolean isInRain() {
        BlockPos blockpos = this.m_142538_();
        return this.f_19853_.m_46758_(blockpos) || this.f_19853_.m_46758_(new BlockPos((double)blockpos.m_123341_(), this.m_142469_().f_82292_, (double)blockpos.m_123343_()));
    }

    public ArmorSet getArmorSet() {
        return ModItems.DROWNED_NECROMANCER_ARMOR;
    }

    static class GoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speedModifier;
        private final Level level;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public GoToWaterGoal(PathfinderMob p_i48910_1_, double p_i48910_2_) {
            this.mob = p_i48910_1_;
            this.speedModifier = p_i48910_2_;
            this.level = p_i48910_1_.f_19853_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.level.m_46461_()) {
                return false;
            }
            if (this.mob.m_20070_()) {
                return false;
            }
            Vec3 vector3d = this.getWaterPos();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.f_82479_;
            this.wantedY = vector3d.f_82480_;
            this.wantedZ = vector3d.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            Random random = this.mob.m_21187_();
            BlockPos blockpos = this.mob.m_142538_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    class LandSummonGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 5;
        public int closeMobSummonRange = 2;

        public LandSummonGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && !this.mob.m_20072_();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), 1.0f, 1.0f);
            this.mob.landSummonAnimationTick = this.mob.landSummonAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && (this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint1 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint2 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint3 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint4 && this.mob.f_19796_.nextBoolean() || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint5 && this.mob.f_19796_.nextBoolean())) {
                SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                mobSummonSpot.mobSpawnRotation = this.mob.f_19796_.nextInt(360);
                mobSummonSpot.setSummonType(2);
                BlockPos summonPos = this.mob.m_142538_().m_142082_(-this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1));
                mobSummonSpot.m_20035_(summonPos, 0.0f, 0.0f);
                if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.m_142538_().m_142082_(-this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1));
                }
                if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.m_142538_();
                }
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)mobSummonSpot);
                PositionUtils.moveToCorrectHeight(mobSummonSpot);
                EntityType<?> entityType = this.getEntityType();
                Mob summonedMob = null;
                Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.m_142538_(), entityType);
                if (entity == null) {
                    mobSummonSpot.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                if (entity instanceof Mob) {
                    summonedMob = (Mob)entity;
                }
                summonedMob.m_6710_(this.target);
                summonedMob.m_6518_((ServerLevelAccessor)((ServerLevel)this.mob.f_19853_), this.mob.f_19853_.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                mobSummonSpot.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                if (this.mob.m_5647_() != null) {
                    Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                    scoreboard.m_6546_(summonedMob.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                }
                mobSummonSpot.summonedEntity = summonedMob;
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.DROWNED_NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.m_21187_().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.f_20562_;
            }
            return entityType;
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (200 + this.mob.f_19796_.nextInt(200));
        }

        public boolean animationsUseable() {
            return this.mob.landSummonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vec3 vector3d = new Vec3(entitySeeing.m_20185_(), entitySeeing.m_20188_(), entitySeeing.m_20189_());
            Vec3 vector3d1 = new Vec3(p_70685_1_.m_20185_(), p_70685_1_.m_20188_(), p_70685_1_.m_20189_());
            if (p_70685_1_.f_19853_ != entitySeeing.f_19853_ || vector3d1.m_82557_(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySeeing)).m_6662_() == HitResult.Type.MISS;
        }
    }

    class SummonGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 6;
        public int closeMobSummonRange = 3;

        public SummonGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.m_20072_();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_STRONG_ATTACK.get(), 1.0f, 1.0f);
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint) {
                for (int i = 0; i < 6; ++i) {
                    SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                    mobSummonSpot.mobSpawnRotation = this.mob.f_19796_.nextInt(360);
                    mobSummonSpot.setSummonType(2);
                    BlockPos summonPos = this.mob.m_142538_().m_142082_(-this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.f_19796_.nextInt(this.mobSummonRange * 2 + 1));
                    mobSummonSpot.m_20035_(summonPos, 0.0f, 0.0f);
                    if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.m_142538_().m_142082_(-this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.f_19796_.nextInt(this.closeMobSummonRange * 2 + 1));
                    }
                    if (mobSummonSpot.m_5830_() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.m_142538_();
                    }
                    ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)mobSummonSpot);
                    EntityType<?> entityType = this.getEntityType();
                    Mob summonedMob = null;
                    Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.m_142538_(), entityType);
                    if (entity == null) {
                        mobSummonSpot.m_142687_(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    if (entity instanceof Mob) {
                        summonedMob = (Mob)entity;
                    }
                    summonedMob.m_6710_(this.target);
                    summonedMob.m_6518_((ServerLevelAccessor)((ServerLevel)this.mob.f_19853_), this.mob.f_19853_.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                    mobSummonSpot.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                    if (this.mob.m_5647_() != null) {
                        Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                        scoreboard.m_6546_(summonedMob.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                    }
                    mobSummonSpot.summonedEntity = summonedMob;
                }
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.DROWNED_NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.m_21187_().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.f_20562_;
            }
            return entityType;
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (200 + this.mob.f_19796_.nextInt(250));
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vec3 vector3d = new Vec3(entitySeeing.m_20185_(), entitySeeing.m_20188_(), entitySeeing.m_20189_());
            Vec3 vector3d1 = new Vec3(p_70685_1_.m_20185_(), p_70685_1_.m_20188_(), p_70685_1_.m_20189_());
            if (p_70685_1_.f_19853_ != entitySeeing.f_19853_ || vector3d1.m_82557_(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySeeing)).m_6662_() == HitResult.Type.MISS;
        }
    }

    class TridentStormGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int tridentSummonRange = 20;

        public TridentStormGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && this.mob.m_20072_();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.tridentStormAnimationTick = this.mob.tridentStormAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)5);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.tridentStormAnimationTick == 30) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_PREPARE_TRIDENT_STORM.get(), 3.0f, 1.0f);
            }
            if (this.target != null && this.mob.tridentStormAnimationTick <= 30 && this.mob.tridentStormAnimationTick >= 10) {
                TridentStormEntity tridentStorm = (TridentStormEntity)((EntityType)ModEntityTypes.TRIDENT_STORM.get()).m_20615_(this.mob.f_19853_);
                tridentStorm.owner = this.mob;
                tridentStorm.m_20035_(new BlockPos(this.mob.m_20185_() - (double)this.tridentSummonRange + (double)this.mob.f_19796_.nextInt(this.tridentSummonRange * 2), this.mob.m_20186_(), this.mob.m_20189_() - (double)this.tridentSummonRange + (double)this.mob.f_19796_.nextInt(this.tridentSummonRange * 2)), 0.0f, 0.0f);
                tridentStorm.m_146922_(this.mob.f_19796_.nextInt(360));
                this.mob.f_19853_.m_7967_((Entity)tridentStorm);
                PositionUtils.moveToCorrectHeight(tridentStorm);
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (100 + this.mob.f_19796_.nextInt(300));
        }

        public boolean animationsUseable() {
            return this.mob.tridentStormAnimationTick <= 0;
        }
    }

    class RainTridentStormGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int tridentSummonRange = 15;

        public RainTridentStormGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) <= 13.0f && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && !this.mob.m_20072_() && this.mob.isInRain();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.rainTridentStormAnimationTick = this.mob.rainTridentStormAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.rainTridentStormAnimationTick == 30) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_PREPARE_TRIDENT_STORM.get(), 3.0f, 1.0f);
            }
            if (this.target != null && this.mob.rainTridentStormAnimationTick <= 30 && this.mob.rainTridentStormAnimationTick >= 10 && this.mob.f_19796_.nextBoolean()) {
                TridentStormEntity tridentStorm = (TridentStormEntity)((EntityType)ModEntityTypes.TRIDENT_STORM.get()).m_20615_(this.mob.f_19853_);
                tridentStorm.owner = this.mob;
                tridentStorm.m_20035_(new BlockPos(this.mob.m_20185_() - (double)this.tridentSummonRange + (double)this.mob.f_19796_.nextInt(this.tridentSummonRange * 2), this.mob.m_20186_(), this.mob.m_20189_() - (double)this.tridentSummonRange + (double)this.mob.f_19796_.nextInt(this.tridentSummonRange * 2)), 0.0f, 0.0f);
                tridentStorm.m_146922_(this.mob.f_19796_.nextInt(360));
                this.mob.f_19853_.m_7967_((Entity)tridentStorm);
                PositionUtils.moveToCorrectHeight(tridentStorm);
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (100 + this.mob.f_19796_.nextInt(300));
        }

        public boolean animationsUseable() {
            return this.mob.rainTridentStormAnimationTick <= 0;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public ShootAttackGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) <= 14.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable() && this.mob.m_20072_();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
            this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_STEAM_MISSILE.get(), 1.5f, 1.0f);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
                this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_ATTACK.get(), 1.5f, 1.0f);
            }
            if (this.target != null && (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 2 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 4 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 6 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 8 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 10)) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, DrownedNecromancerEntity.this.m_146908_());
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                DrownedNecromancerOrbEntity necromancerOrb = new DrownedNecromancerOrbEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1 + this.mob.f_19796_.nextGaussian() * 1.25, d2 + this.mob.f_19796_.nextGaussian() * 0.5, d3 + this.mob.f_19796_.nextGaussian() * 1.25);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                this.mob.f_19853_.m_7967_((Entity)necromancerOrb);
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + 20;
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class RainShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public RainShootAttackGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable() && !this.mob.m_20072_() && this.mob.isInRain();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.rainShootAnimationTick = this.mob.rainShootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)8);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint) {
                this.mob.m_5496_((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SHOOT.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 3 || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 6 || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 9)) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, DrownedNecromancerEntity.this.m_146908_());
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                DrownedNecromancerOrbEntity necromancerOrb = new DrownedNecromancerOrbEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1 + this.mob.f_19796_.nextGaussian() * 1.0, d2 + this.mob.f_19796_.nextGaussian() * 0.25, d3 + this.mob.f_19796_.nextGaussian() * 1.0);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                this.mob.f_19853_.m_7967_((Entity)necromancerOrb);
            }
        }

        public boolean animationsUseable() {
            return this.mob.rainShootAnimationTick <= 0;
        }
    }

    class LandShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public LandShootAttackGoal(DrownedNecromancerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable() && !this.mob.m_20071_();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.landShootAnimationTick = this.mob.landShootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.landShootAnimationTick == this.mob.landShootAnimationActionPoint) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.m_146908_());
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                NecromancerOrbEntity necromancerOrb = new NecromancerOrbEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1, d2, d3);
                necromancerOrb.setDelayedForm(true);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                this.mob.f_19853_.m_7967_((Entity)necromancerOrb);
                this.mob.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.landShootAnimationTick <= 0;
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedNecromancerEntity drowned;

        public GoToBeachGoal(DrownedNecromancerEntity p_i48911_1_, double p_i48911_2_) {
            super((PathfinderMob)p_i48911_1_, p_i48911_2_, 8, 2);
            this.drowned = p_i48911_1_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.drowned.f_19853_.m_46461_() && this.drowned.f_19853_.m_46471_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.f_19853_.m_5736_() - 7);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader p_179488_1_, BlockPos p_179488_2_) {
            BlockPos blockpos = p_179488_2_.m_7494_();
            return p_179488_1_.m_46859_(blockpos) && p_179488_1_.m_46859_(blockpos.m_7494_()) ? p_179488_1_.m_8055_(p_179488_2_).m_60634_((BlockGetter)p_179488_1_, p_179488_2_, (Entity)this.drowned) : false;
        }

        public void m_8056_() {
            this.drowned.m_32398_(false);
            this.drowned.f_21344_ = (PathNavigation)this.drowned.f_32341_;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedNecromancerEntity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(DrownedNecromancerEntity p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean m_8036_() {
            return !this.drowned.f_19853_.m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.m_32391_())) {
                Vec3 vector3d = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vector3d == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.m_32398_(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.m_32398_(false);
        }
    }
}

