/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import com.infamous.dungeons_mobs.network.message.AnimatedPropsMessage;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;

public class ReplacedModdedAttackGoal<T extends Mob>
extends Goal {
    public T mob;
    @Nullable
    public LivingEntity target;
    private SoundEvent soundEvent;
    private int cooldown;
    private long lastUseTime;

    public ReplacedModdedAttackGoal(T mob, SoundEvent soundEvent, int cooldown) {
        this.soundEvent = soundEvent;
        this.cooldown = cooldown;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        this.mob = mob;
        this.target = mob.m_5448_();
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        long i = ((Mob)this.mob).f_19853_.m_46467_();
        if (i - this.lastUseTime < (long)this.cooldown) {
            return false;
        }
        this.target = this.mob.m_5448_();
        return this.target != null && !this.mob.m_21254_() && (double)this.mob.m_20270_((Entity)this.target) <= this.getAttackReachSqr(this.target) && this.animationsUseable() && this.mob.m_142582_((Entity)this.target);
    }

    public boolean m_8045_() {
        return this.target != null && !this.animationsUseable();
    }

    public void m_8056_() {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        cap.setAttackAnimationTick(cap.getAttackAnimationLength());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.mob), (Object)new AnimatedPropsMessage(this.mob.m_142049_(), cap));
        this.lastUseTime = ((Mob)this.mob).f_19853_.m_46467_();
        ((Mob)this.mob).f_19853_.m_7605_(this.mob, (byte)4);
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        if (cap.getAttackAnimationTick() == cap.getAttackAnimationActionPoint() && this.soundEvent != null) {
            this.mob.m_5496_(this.soundEvent, 1.0f, 1.0f);
        }
        if (this.target != null && this.mob.m_20270_((Entity)this.target) < 4.0f && cap.getAttackAnimationTick() == cap.getAttackAnimationActionPoint()) {
            this.mob.m_7327_((Entity)this.target);
        }
    }

    public void m_8041_() {
        if (this.target != null && !this.isShieldDisabled((Mob)this.mob) && this.shouldBlockForTarget(this.target) && this.mob.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK) && this.mob.m_21187_().nextInt(4) == 0) {
            this.mob.m_6672_(InteractionHand.OFF_HAND);
        }
    }

    public boolean isShieldDisabled(Mob shieldUser) {
        return shieldUser instanceof IShieldUser && ((IShieldUser)shieldUser).isShieldDisabled();
    }

    public boolean shouldBlockForTarget(LivingEntity target) {
        return !(target instanceof Mob) || ((Mob)target).m_5448_() == this.mob;
    }

    public boolean animationsUseable() {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        return cap.getAttackAnimationTick() <= 0;
    }

    public double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
    }
}

