/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class SimpleRangedAttackGoal<T extends Mob>
extends Goal {
    protected final T mob;
    protected final BiConsumer<T, LivingEntity> performRangedAttack;
    protected final Predicate<ItemStack> weaponPredicate;
    protected LivingEntity target;
    protected int attackTime = -1;
    protected final double speedModifier;
    protected int seeTime;
    protected final int attackIntervalMin;
    protected final int attackIntervalMax;
    protected final float attackRadius;
    protected final float attackRadiusSqr;

    public SimpleRangedAttackGoal(T p_i1649_1_, Predicate<ItemStack> weaponPredicate, BiConsumer<T, LivingEntity> performRangedAttack, double speedModifier, int attackInterval, float attackRadius) {
        this(p_i1649_1_, weaponPredicate, performRangedAttack, speedModifier, attackInterval, attackInterval, attackRadius);
    }

    public SimpleRangedAttackGoal(T p_i1650_1_, Predicate<ItemStack> weaponPredicate, BiConsumer<T, LivingEntity> performRangedAttack, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        this.mob = p_i1650_1_;
        this.weaponPredicate = weaponPredicate;
        this.performRangedAttack = performRangedAttack;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.mob.m_21093_(this.weaponPredicate)) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.mob.m_21093_(this.weaponPredicate)) {
            return false;
        }
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public void m_8037_() {
        double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
            float lvt_5_1_ = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.performRangedAttack.accept(this.mob, this.target);
            this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            float f2 = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
            this.attackTime = Mth.m_14143_((float)(f2 * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

